
<?php $__env->startSection('title',$career->lang->title); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e($translations['meta_description']); ?>">
    <meta name="keywords" content="<?php echo e($translations['meta_keywords']); ?>">
    <meta name="author" content="<?php echo e($translations['website']); ?>"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="rs-breadcrumbs img3">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title"><?php echo e($career->lang->title); ?> </h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="<?php echo e(url(session('language').'/')); ?>"><?php echo e($translations['home']); ?></a></span>
                    <span class="post"><?php echo e($career->lang->title); ?> </span>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumbs End -->

    <!-- Careers Single Section Start -->
    <div class="rs-careers-single pt-120 pb-100 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 pr-45 md-pr-15">
                    <div class="career-inner-section">

                        <div class="career-img">
                            <img src="<?php echo e($career->image); ?>" alt="<?php echo e($career->lang->title); ?>">
                        </div>

                    <?php echo $career->lang->description; ?>


                        <!-- Contact Start -->
                        <div class="contact-section mt-5">
                            <div class="sec-title mb-28">
                                <span class="sub-text sub-text2"> <?php echo e($translations['how_to_apply']); ?></span>
                                <h2 class="title title3">

                                    <?php echo e($translations['submit_cv']); ?>

                                </h2>
                            </div>
                            <div class="contact-wrap">
                                <div id="form-messages">
                                    <?php echo $__env->make('backend.include.errors', [], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                </div>
                                <form method="post" action="<?php echo e(url('submit-cv')); ?>" enctype="multipart/form-data">
                                    <fieldset>
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="text" id="name" name="name" placeholder="<?php echo e($translations['name']); ?>" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="text" id="email" name="email" placeholder="<?php echo e($translations['email']); ?>" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="number" id="yearsOfExperience" name="years" placeholder="<?php echo e($translations['years_of_experience']); ?>" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="text" id="phone" name="phone" placeholder="<?php echo e($translations['phone']); ?>" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="number" id="Age" name="age" placeholder="<?php echo e($translations['age']); ?>" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="text" id="JobTitle" name="job_title" placeholder="<?php echo e($translations['job_title']); ?>" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <label for="file"><?php echo e($translations['attach_file']); ?>: </label>
                                                <input class="file form-control mt-3" type="file" id="file" name="cv" required="">
                                            </div>
                                        </div>
                                        <div class="btn-part mt-3">
                                            <div class="form-group mb-0">
                                                <input class="readon details form-submit" type="submit" value="<?php echo e($translations['submit_cv']); ?>">
                                            </div>
                                        </div>
                                    </fieldset>
                                </form>
                            </div>
                        </div>

                        <!-- Contact End -->
                    </div>
                </div>
                <div class="col-lg-4">

                    <div class="services-add">
                        <div class="address-wrap mb-35">
                            <div class="icon-part">
                                <i class="fa fa-phone"></i>
                            </div>
                        </div>
                        <h2 class="title"><?php echo e($translations['Have_any_questions']); ?></h2>
                        <div class="contact">
                            <a href="tel:<?php echo e($settings['mobile']); ?>"><?php echo e($settings['mobile']); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layout.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>