
<?php $__env->startSection('title','الصفحة الرئيسية'); ?>
<?php $__env->startSection('content'); ?>
<?php

use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="app-content container center-layout mt-2">
    <div class="content-wrapper">
        <div class="content-header row">
        </div>
        <style>
            body {
                font: 10px sans-serif;
            }

            .axis path,
            .axis line {
                fill: none;
                stroke: #000;
                shape-rendering: crispEdges;
            }

            .bar {
                fill: orange;
            }

            .bar:hover {
                fill: orangered ;
            }

            .x.axis path {
                display: none;
            }

            .d3-tip {
                line-height: 1;
                font-weight: bold;
                padding: 12px;
                background: rgba(0, 0, 0, 0.8);
                color: #fff;
                border-radius: 2px;
            }

            /* Creates a small triangle extender for the tooltip */
            .d3-tip:after {
                box-sizing: border-box;
                display: inline;
                font-size: 10px;
                width: 100%;
                line-height: 1;
                color: rgba(0, 0, 0, 0.8);
                content: "\25BC";
                position: absolute;
                text-align: center;
            }

            /* Style northward tooltips differently */
            .d3-tip.n:after {
                margin: -1px 0 0 0;
                top: 100%;
                left: 0;
            }
            h5{
                color: black;
            }
        </style>

        <div class="content-body"><!-- Stats -->
            <div class="row">
                <div class="col-xl-3 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="media align-items-stretch">
                                <div class="p-2 text-center bg-primary bg-darken-2">
                                    <i class="ft-list font-large-2 white"></i>
                                </div>
                                <div class="p-2  white media-body">
                                    <h5>Services</h5>
                                    <h5 class="text-bold-400 mb-0"><i class="feather icon-arrow-up"></i> <?php echo e($services); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="media align-items-stretch">
                                <div class="p-2 text-center bg-success bg-darken-2">
                                    <i class="ft-file-text font-large-2 white"></i>
                                </div>
                                <div class="p-2 white media-body">
                                    <h5>News</h5>
                                    <h5 class="text-bold-400 mb-0"><i class="feather icon-arrow-up"></i> <?php echo e($news); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="media align-items-stretch">
                                <div class="p-2 text-center bg-warning bg-darken-2">
                                    <i class="ft-fast-forward font-large-2 white"></i>
                                </div>
                                <div class="p-2  white media-body">
                                    <h5>Events</h5>
                                    <h5 class="text-bold-400 mb-0"><i class="feather icon-arrow-up"></i> <?php echo e($events); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        
                <div class="col-xl-3 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="media align-items-stretch">
                                <div class="p-2 text-center bg-warning bg-darken-2">
                                    <i class="ft-users font-large-2 white"></i>
                                </div>
                                <div class="p-2 white media-body">
                                    <h5>Partners</h5>
                                    <h5 class="text-bold-400 mb-0"><i class="feather icon-arrow-up"></i> <?php echo e($partners); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="media align-items-stretch">
                                <div class="p-2 text-center bg-warning bg-darken-2">
                                    <i class="ft-users font-large-2 white"></i>
                                </div>
                                <div class="p-2 white media-body">
                                    <h5>Collaborators</h5>
                                    <h5 class="text-bold-400 mb-0"><i class="feather icon-arrow-up"></i> <?php echo e($collaborators); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="media align-items-stretch">
                                <div class="p-2 text-center bg-primary bg-darken-2">
                                    <i class="ft-file font-large-2 white"></i>
                                </div>
                                <div class="p-2  white media-body">
                                    <h5>C.V.s</h5>
                                    <h5 class="text-bold-400 mb-0"><i class="feather icon-arrow-up"></i> <?php echo e($cvs); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
          
                <div class="col-xl-3 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="media align-items-stretch">
                                <div class="p-2 text-center bg-danger bg-darken-2">
                                    <i class="ft-user-plus font-large-2 white"></i>
                                </div>
                                <div class="p-2 white media-body">
                                    <h5>Subscribers</h5>
                                    <h5 class="text-bold-400 mb-0"><i class="feather icon-arrow-up"></i> <?php echo e($subscribers); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="http://d3js.org/d3.v3.min.js"></script>
<script src="http://labratrevenge.com/d3-tip/javascripts/d3.tip.v0.6.3.js"></script>


<script>
    var margin = {top: 40, right: 20, bottom: 30, left: 40},
            width = 960 - margin.left - margin.right,
            height = 500 - margin.top - margin.bottom;

    var formatPercent = d3.format(".0%");

    var x = d3.scale.ordinal()
            .rangeRoundBands([0, width], .1);

    var y = d3.scale.linear()
            .range([height, 0]);

    var xAxis = d3.svg.axis()
            .scale(x)
            .orient("bottom");

    var yAxis = d3.svg.axis()
            .scale(y)
            .orient("left")
            .tickFormat(formatPercent);

    var tip = d3.tip()
            .attr('class', 'd3-tip')
            .offset([-10, 0])
            .html(function (d) {
                return "<strong>Frequency:</strong> <span style='color:red'>" + d.frequency + "</span>";
            })

    var svg = d3.select("body").append("svg")
            .attr("width", width + margin.left + margin.right)
            .attr("height", height + margin.top + margin.bottom)
            .append("g")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

    svg.call(tip);

    var data = JSON.parse(document.getElementById('data').innerHTML);

//d3.tsv("data.tsv", type, function(error, data) {
    x.domain(data.map(function (d) {
        return d.letter;
    }));
    y.domain([0, d3.max(data, function (d) {
            return d.frequency;
        })]);

    svg.append("g")
            .attr("class", "x axis")
            .attr("transform", "translate(0," + height + ")")
            .call(xAxis);

    svg.append("g")
            .attr("class", "y axis")
            .call(yAxis)
            .append("text")
            .attr("transform", "rotate(-90)")
            .attr("y", 6)
            .attr("dy", ".71em")
            .style("text-anchor", "end")
            .text("Frequency");

    svg.selectAll(".bar")
            .data(data)
            .enter().append("rect")
            .attr("class", "bar")
            .attr("x", function (d) {
                return x(d.letter);
            })
            .attr("width", x.rangeBand())
            .attr("y", function (d) {
                return y(d.frequency);
            })
            .attr("height", function (d) {
                return height - y(d.frequency);
            })
            .on('mouseover', tip.show)
            .on('mouseout', tip.hide)

//});

    function type(d) {
        d.frequency = +d.frequency;
        return d;
    }


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>