<?php

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register web routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | contains the "web" middleware group. Now create something great!
  |
 */
Route::get('/cache_flush', function() {
    \Cache::flush();
});

Route::get('/data', 'Front\HomeController@getData');

Route::get('/sent_reset', 'Front\HomeController@sendReset');
Route::get('test-email', function() {
    $headers = 'MIME-Version: 1.0' . "\r\n";

    $headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";
    $headers .= 'From: info@reeqalnahl' . "\r\n" .
        'X-Mailer: PHP/' . phpversion();
    mail('eng.ahmedelsadany1@gmail.com', 'test', 'test', $headers);
});
Route::any('media/get/{offset?}/{type?}/{q?}', ["as" => "media.index", "uses" => "Backend\MediaController@index"]);
Route::any('media/save_gallery', ["as" => "media.save_gallery", "uses" => "Backend\MediaController@save_gallery"]);
Route::any('media/save', ["as" => "media.save", "uses" => "Backend\MediaController@save"]);
Route::any('media/delete', ["as" => "media.delete", "uses" => "Backend\MediaController@delete"]);
Route::any('media/upload', ["as" => "media.upload", "uses" => "Backend\MediaController@upload"]);
Route::any('media/link', ["as" => "media.link", "uses" => "Backend\MediaController@link"]);
Route::any('media/crop', ["as" => "media.crop", "uses" => "Backend\MediaController@cropImage"]);
Route::group(['middleware' => ['web']], function() {
    Route::post('backend/ajax/upload', 'Helpers\AjaxController@anyUpload');
    Route::post('backend/upload', 'Helpers\AjaxController@upload');
    Route::any('ajax/editorupload', 'Helpers\AjaxController@anyEditorupload');
    Route::any('ajax/removeimage', 'Helpers\AjaxController@anyRemoveimage');
    Route::any('ajax/browse', 'Helpers\AjaxController@anyBrowse');
    Route::any('image/hidden/{id}', 'Backend\DashboardController@hidden');
});
Route::any('backend/messages/send', 'Backend\MessagesController@anySend');
Route::any('backend/replace', 'Backend\DashboardController@replace');

Route::group(['namespace' => 'Backend', 'middleware' => ['web', 'backend', 'role'], 'prefix' => '/backend'], function() {
    Route::any('update-profile', 'ProfileController@UpdateProfile');
    Route::any('update-password', 'ProfileController@UpdatePassword');
    Route::any('pages/create', 'PagesController@create');
    Route::any('pages/update/{id}', 'PagesController@update');
    Route::any('pages/delete/{id}', 'PagesController@delete');
    Route::any('pages', 'PagesController@index');
    Route::any('pages/generate', 'PagesController@generate');
    Route::any('backend_users', 'BackendUsersController@index');
    Route::any('backend_users/create', 'BackendUsersController@create');
    Route::any('backend_users/update/{id}', 'BackendUsersController@update');
    Route::any('backend_users/update-pass/{id}', 'BackendUsersController@updatepass');
    Route::any('backend_users/delete/{id}', 'BackendUsersController@delete');
    Route::any('backend_users/active/{id}', 'BackendUsersController@active');
    Route::any('roles', 'RolesController@index');
    Route::any('roles/create', 'RolesController@create');
    Route::any('roles/update/{id}', 'RolesController@update');
    Route::any('roles/delete/{id}', 'RolesController@delete');
    Route::any('roles/actions/{id}', 'RolesController@actions');
    //Dashboard
    Route::get('dashboard', 'DashboardController@anyIndex');
    Route::get('/', 'DashboardController@anyIndex');



    Route::get('requests/contacts', 'RequestsController@contact');
    Route::get('requests/contacts/download', 'RequestsController@downloadcontact');
    Route::get('requests/orders', 'RequestsController@orders');
    Route::get('requests/orders/download', 'RequestsController@downloadorders');

    Route::get('careers', 'CareersController@index');
    Route::get('careers/delete/{id}', 'CareersController@anyDelete');
    Route::get('careers/download', 'CareersController@download');
    Route::get('bookings', 'BookingsController@index');
    Route::get('bookings/download', 'BookingsController@download');

    Route::get('subscribers', 'SubscribersController@index');
    Route::get('subscribers/download', 'SubscribersController@download');
    Route::get('subscribers/delete/{id}', 'SubscribersController@anyDelete');

    //Banners
    Route::any('banners', 'BannersController@anyIndex');
    Route::any('banners/create', 'BannersController@anyCreate');
    Route::any('banners/edit/{id}', 'BannersController@anyEdit');
    Route::get('banners/delete/{id}', 'BannersController@anyDelete');
    //Galleries
    Route::any('galleries', 'GalleriesController@anyIndex');
    Route::any('galleries/create', 'GalleriesController@anyCreate');
    Route::any('galleries/edit/{id}', 'GalleriesController@anyEdit');
    Route::get('galleries/delete/{id}', 'GalleriesController@anyDelete');
    //Statistics
    Route::any('statistics', 'StatisticsController@anyIndex');
    Route::any('statistics/create', 'StatisticsController@anyCreate');
    Route::any('statistics/edit/{id}', 'StatisticsController@anyEdit');
    Route::get('statistics/delete/{id}', 'StatisticsController@anyDelete');
    //started_section
    Route::any('started_sections', 'StartedSectionsController@anyIndex');
    Route::any('started_sections/create', 'StartedSectionsController@anyCreate');
    Route::any('started_sections/edit/{id}', 'StartedSectionsController@anyEdit');
    Route::get('started_sections/delete/{id}', 'StartedSectionsController@anyDelete');
    //CompanyEvents
    Route::any('company_events', 'CompanyEventsController@anyIndex');
    Route::any('company_events/create', 'CompanyEventsController@anyCreate');
    Route::any('company_events/edit/{id}', 'CompanyEventsController@anyEdit');
    Route::get('company_events/delete/{id}', 'CompanyEventsController@anyDelete');
    //Testimonials
    Route::any('testimonials', 'TestimonialsController@anyIndex');
    Route::any('testimonials/create', 'TestimonialsController@anyCreate');
    Route::any('testimonials/edit/{id}', 'TestimonialsController@anyEdit');
    Route::get('testimonials/delete/{id}', 'TestimonialsController@anyDelete');
    //Goals
    Route::any('goals', 'GoalsController@anyIndex');
    Route::any('goals/create', 'GoalsController@anyCreate');
    Route::any('goals/edit/{id}', 'GoalsController@anyEdit');
    Route::get('goals/delete/{id}', 'GoalsController@anyDelete');
    //Categories
    Route::any('categories', 'CategoriesController@anyIndex');
    Route::any('categories/create', 'CategoriesController@anyCreate');
    Route::any('categories/edit/{id}', 'CategoriesController@anyEdit');
    Route::get('categories/delete/{id}', 'CategoriesController@anyDelete');

    //Features
    Route::any('features', 'FeaturesController@anyIndex');
    Route::any('features/create', 'FeaturesController@anyCreate');
    Route::any('features/edit/{id}', 'FeaturesController@anyEdit');
    Route::get('features/delete/{id}', 'FeaturesController@anyDelete');
    //Translations
    Route::any('translations', 'TranslationsController@anyIndex');
    Route::any('translations/create', 'TranslationsController@anyCreate');
    Route::any('translations/edit/{id}', 'TranslationsController@anyEdit');
    Route::get('translations/delete/{id}', 'TranslationsController@anyDelete');
    //Menus
    Route::any('menus', 'MenusController@anyIndex');
    Route::any('menus/create', 'MenusController@anyCreate');
    Route::any('menus/order', 'MenusController@order');
    Route::any('menus/edit/{id}', 'MenusController@anyEdit');
    Route::get('menus/delete/{id}', 'MenusController@anyDelete');
    //MenusLinks
    Route::any('menus_links/order', 'MenusLinksController@order');
    Route::any('menus_links/{id}', 'MenusLinksController@anyIndex');
    Route::any('menus_links/create/{id}', 'MenusLinksController@anyCreate');
    Route::any('menus_links/edit/{id}', 'MenusLinksController@anyEdit');
    Route::get('menus_links/delete/{id}', 'MenusLinksController@anyDelete');
    //Partners
    Route::any('partners', 'PartnersController@anyIndex');
    Route::any('partners/create', 'PartnersController@anyCreate');
    Route::any('partners/edit/{id}', 'PartnersController@anyEdit');
    Route::get('partners/delete/{id}', 'PartnersController@anyDelete');
    //collaborators
    Route::any('collaborators', 'CollaboratorsController@anyIndex');
    Route::any('collaborators/create', 'CollaboratorsController@anyCreate');
    Route::any('collaborators/edit/{id}', 'CollaboratorsController@anyEdit');
    Route::get('collaborators/delete/{id}', 'CollaboratorsController@anyDelete');

    //IndexSections
    Route::any('index_sections', 'IndexSectionsController@anyIndex');
    Route::any('index_sections/create', 'IndexSectionsController@anyCreate');
    Route::any('index_sections/edit/{id}', 'IndexSectionsController@anyEdit');
    Route::get('index_sections/delete/{id}', 'IndexSectionsController@anyDelete');
    //Services
    Route::any('services', 'ServicesController@anyIndex');
    Route::any('services/create', 'ServicesController@anyCreate');
    Route::any('services/edit/{id}', 'ServicesController@anyEdit');
    Route::get('services/delete/{id}', 'ServicesController@anyDelete');
    //Services
    Route::any('success_stories', 'SuccessStoriesController@anyIndex');
    Route::any('success_stories/create', 'SuccessStoriesController@anyCreate');
    Route::any('success_stories/edit/{id}', 'SuccessStoriesController@anyEdit');
    Route::get('success_stories/delete/{id}', 'SuccessStoriesController@anyDelete');
    //Certifications
    Route::any('certifications', 'CertificationsController@anyIndex');
    Route::any('certifications/create', 'CertificationsController@anyCreate');
    Route::any('certifications/edit/{id}', 'CertificationsController@anyEdit');
    Route::any('certifications/index/{id}', 'CertificationsController@addToIndex');
    Route::get('certifications/delete/{id}', 'CertificationsController@anyDelete');

    //MainCategories
    Route::any('main_categories', 'MainCategoriesController@anyIndex');
    Route::any('main_categories/create', 'MainCategoriesController@anyCreate');
    Route::any('main_categories/edit/{id}', 'MainCategoriesController@anyEdit');
    Route::get('main_categories/delete/{id}', 'MainCategoriesController@anyDelete');

    //SecondaryCategories
    Route::any('secondary_categories', 'SecondaryCategoriesController@anyIndex');
    Route::any('secondary_categories/create', 'SecondaryCategoriesController@anyCreate');
    Route::any('secondary_categories/edit/{id}', 'SecondaryCategoriesController@anyEdit');
    Route::get('secondary_categories/delete/{id}', 'SecondaryCategoriesController@anyDelete');

    //Products
    Route::any('products', 'ProductsController@anyIndex');
    Route::any('products/create', 'ProductsController@anyCreate');
    Route::any('products/edit/{id}', 'ProductsController@anyEdit');
    Route::get('products/delete/{id}', 'ProductsController@anyDelete');

    //News
    Route::any('news', 'NewsController@anyIndex');
    Route::any('news/create', 'NewsController@anyCreate');
    Route::any('news/edit/{id}', 'NewsController@anyEdit');
    Route::get('news/delete/{id}', 'NewsController@anyDelete');
    //Events
    Route::any('events', 'EventsController@anyIndex');
    Route::any('events/create', 'EventsController@anyCreate');
    Route::any('events/edit/{id}', 'EventsController@anyEdit');
    Route::any('events/index/{id}', 'EventsController@addToIndex');
    Route::get('events/delete/{id}', 'EventsController@anyDelete');

    Route::get('/', 'DashboardController@anyIndex');
    //Languages
    Route::any('languages', 'LanguagesController@anyIndex');
    Route::any('languages/create', 'LanguagesController@anyCreate');
    Route::any('languages/edit/{id}', 'LanguagesController@anyEdit');
    Route::get('languages/delete/{id}', 'LanguagesController@getDelete');
    Route::get('languages/restore/{id}', 'LanguagesController@getRestore');
    Route::get('languages/delete-forever/{id}', 'LanguagesController@getDeleteForever');
    Route::get('languages/defaulting/{id}', 'LanguagesController@getDefaulting');
    Route::get('languages/activated/{id}', 'LanguagesController@getActivated');
    Route::any('languages/files/{id}', 'LanguagesController@anyFiles');
    Route::get('languages/choose-language/{id}', 'LanguagesController@getChooseLanguage');
    // StaticPages
    Route::any('staticpages', 'StaticPagesController@anyIndex');
    Route::any('staticpages/create', 'StaticPagesController@anyCreate');
    Route::any('staticpages/edit/{id}', 'StaticPagesController@anyEdit');
    Route::get('staticpages/delete/{id}', 'StaticPagesController@anyDelete');
////    // StaticPages Languages
////    Route::get('staticpages/languages/{id}', 'StaticPagesController@anyLanguages');
////    Route::any('staticpages/create-language/{id}', 'StaticPagesController@anyCreateLanguage');
////    Route::any('staticpages/edit-language/{id}', 'StaticPagesController@anyEditLanguage');
////    Route::any('staticpages/delete-language/{id}', 'StaticPagesController@anyDeleteLanguage');
//   
    Route::get('contacts', 'ContactsController@anyIndex');
    Route::any('contacts/send/{id}', 'ContactsController@send');
    Route::any('contacts/download', 'ContactsController@download');
    Route::any('contacts/delete/{id}', 'ContactsController@anyDelete');
    Route::any('search', 'SearchController@anyIndex');
    Route::any('search_user', 'SearchController@search');
    Route::any('users_notification', 'NotificationsController@usersSend');
    Route::any('delegates_notification', 'NotificationsController@delegatesSend');
    //rate
    Route::get('delegatesratings', 'RatingsController@index');
    Route::get('usersratings', 'RatingsController@anyIndex');
    Route::get('ratings/delete/{id}', 'RatingsController@anyDelete');

//setting
    Route::any('settings', 'SettingsController@index');
    Route::any('settings/create/{id}', 'SettingsController@create');
    Route::any('settings/update/{id}', 'SettingsController@update');
    Route::any('settings/delete/{id}', 'SettingsController@delete');
});
Route::group(['namespace' => 'Front','prefix' => '{language_symbol?}', 'middleware' => [ 'shared', 'web','MinifyHtml','frontLanguage']], function($language_symbole) {
    Route::get('/', 'HomeController@index');
    Route::get('clients','HomeController@clients');
    Route::get('partners','HomeController@partners');
    Route::get('shop','ProductsController@index');
    Route::get('shop/category/{id}','ProductsController@subCategories');
    Route::get('products/{id}','ProductsController@products');
    Route::get('products/show/{id}','ProductsController@show');
    Route::get('services','ServicesController@index');
    Route::get('services/show/{id}/{name?}','ServicesController@show');
    Route::get('offers','OffersController@index');
    Route::get('offers/show/{id}/{name?}','OffersController@show');
    Route::get('gallary','GallariesController@index');
    Route::get('gallary/show/{id}/{name?}','GallariesController@show');
    Route::get('blog','NewsController@index');
    Route::get('blogs/show/{id}/{name?}','NewsController@show');

    Route::get('/about-us', 'HomeController@about');
    Route::get('/about_us', 'HomeController@about');
    Route::get('/contact_us', 'HomeController@contact');
    Route::get('/contact-us', 'HomeController@contact');

    Route::get('/terms', 'HomeController@terms');
    Route::get('/get-started', 'HomeController@getStarted');
    Route::get('/privacy', 'HomeController@privacy');
    Route::get('/careers', 'HomeController@careers');

    Route::get('news','NewsController@index');
    Route::get('news/show/{id}/{name?}','NewsController@show');

});
Route::group(['namespace' => 'Front', 'middleware' => [ 'web']], function() {

    Route::get('change-language/{id}', 'HomeController@changeLanguage');
    Route::post('/contact-us', 'HomeController@store');
    Route::post('/subscribe', 'HomeController@Subscribe');
    Route::post('/submit-cv', 'HomeController@submitCv');
});
