<?php

use Illuminate\Http\Request;

/*
  |--------------------------------------------------------------------------
  | API Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register API routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | is assigned the "api" middleware group. Enjoy building your API!
  |
 */
Route::group(['namespace' => 'Api', 'middleware' => ['apiLanguage']], function() {
    Route::post('users/sendsms', 'AuthController@sendSms');
    Route::post('users/check-code', 'AuthController@checkCode');
    //users
    Route::any('users/login', 'AuthController@login');
    Route::any('users/forget_password', 'AuthController@forgetPassword');
    Route::any('users/check_reset_code', 'AuthController@checkResetCode');
    Route::any('users/reset_password', 'AuthController@resetPassword');
    Route::any('users/register', 'AuthController@register');






    Route::group(['middleware' => ['api', 'apiauth']], function() {
        Route::any('users/orders/add', 'OrdersController@add');
        Route::any('users/orders', 'OrdersController@orders');
        Route::any('users/orders/offers', 'OrdersController@offer');
        Route::any('users/orders/unfinished', 'OrdersController@unFinished');
        Route::any('users/orders/finished', 'OrdersController@Finished');
        Route::any('users/orders/new', 'OrdersController@newOrders');
        Route::any('users/orders/choose-offer', 'OrdersController@chooseOffer');
        Route::any('users/orders/finish-offer', 'OrdersController@finishOffer');
        Route::any('users/orders/cancel', 'OrdersController@cancelOrder');
        Route::any('users/rating/add', 'RatingController@add');
        Route::any('users/ratings', 'RatingController@ratings');

        Route::any('users/logout', 'AuthController@logout');

        Route::any('users/myaccount', 'UserController@myAccount');
        Route::any('users/account/update-profile', 'UserController@UpdateProfile');
        Route::any('users/account/update-password', 'UserController@UpdatePassword');
    });

    Route::any('delegates/login', 'Supplier\AuthController@login');

    Route::group(['middleware' => ['api', 'apidelegate'], 'namespace' => 'Supplier'], function() {
        Route::any('delegates/orders', 'CheckoutController@orders');
        Route::any('delegates/order', 'CheckoutController@assignOrder');
        Route::any('delegates/myorders', 'CheckoutController@myOrder');
        Route::any('delegates/finishedorders', 'CheckoutController@finishedOrders');
        Route::any('delegates/orders/finish', 'CheckoutController@finishOrder');
        Route::any('technicans/offers', 'CheckoutController@orders');
        Route::any('technicans/orders/assign', 'CheckoutController@assignOrder');
        Route::any('technicans/chats', 'MessagesController@chats');
        Route::any('technicans/chats/show', 'MessagesController@chat');
        Route::any('technicans/chats/addmessage', 'MessagesController@addMessage');
        Route::any('delegates/logout', 'AuthController@logout');

        Route::any('delegates/myaccount', 'UserController@myAccount');
        Route::any('delegates/account/update-profile', 'UserController@UpdateProfile');
        Route::any('delegates/account/update-password', 'UserController@UpdatePassword');
    });
});
