@extends('front.layout.master')
@section('title',$category->lang->name)
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')

    <!-- Banner Start -->
    <div class="rs-breadcrumbs img1">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$category->lang->name}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/shop/category/'.$category->main_category_id)}}">{{$category->category?$category->category->lang->name:''}}</a></span>
                    <span class="post">{{$category->lang->name}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!--Shop part start-->
    <div class="rs-shop-part pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row align-items-center rs-vertical-middle shorting mb-50 md-mb-30">


            </div>
            <div class="row">
                @foreach($products as $product)
                <div class="col-lg-4 col-md-6 mb-80 md-mb-40">
                    <div class="product-list">
                        <div class="image-product">
                            <a  href="{{url(session('language').'/products/show/'.$product->id)}}"> <img  class="miages-size-shop" src="{{$product->image}}" alt=""></a>
                            <div class="overley">
                                <div class="product-info">
                                    <a href="{{url(session('language').'/products/show/'.$product->id)}}">{{$translations['read_more']}}</a>
                                </div>
                            </div>
                        </div>
                        <div class="content-desc text-center">
                            <h2 class="loop-product-title"><a href="{{url(session('language').'/products/show/'.$product->id)}}">{{$product->lang->name}} </a></h2>
                            @if($product->price>0)
                                <span class="price">{{$product->price}}</span>
                            @endif
                        </div>
                    </div>
                </div>
                @endforeach
                @if($products->lastPage()>1)
                <div class="col-lg-12 text-center pt-40">
                    <ul class="pagination-part">
                        @for($i=1;$i<=$products->lastPage();$i++)
                        <li class="{{$i==$products->currentPage()?'active':''}}"><a href="{{url()->current().'?page='.$i}}">{{$i}}</a></li>
                        @endfor
                            @if($products->lastPage()>1&&$products->currentPage()<$products->lastPage())
                                <?php $next= $products->currentPage()+1;?>
                            <li><a class="next-page" href="{{url()->current().'?page='.$next}}">{{$translations['next']}}</a></li>
                            @endif
                    </ul>
                </div>
                @endif
            </div>
        </div>
    </div>
    <!--Shop part end-->
@endsection