@extends('front.layout.master')
@section('title',$translations['main_categories'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')

    <!-- Banner Start -->
    <div class="rs-breadcrumbs img1">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$translations['main_categories']}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['shop']}}</a></span>
                    <span class="post">{{$translations['main_categories']}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!--Shop part start-->
    <div class="rs-shop-part pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row align-items-center rs-vertical-middle shorting mb-50 md-mb-30">


            </div>
            <div class="row">
                @foreach($categories as $category)
                <div class="col-lg-4 col-md-6 mb-80 md-mb-40">
                    <div class="product-list">
                        <div class="image-product">
                            <a  href="{{url(session('language').'/shop/category/'.$category->id)}}"> <img  class="miages-size-shop" src="{{$category->image}}" alt=""></a>
                            <div class="overley">
                                <div class="product-info">
                                    <a href="{{url(session('language').'/shop/category/'.$category->id)}}">{{$translations['read_more']}}</a>
                                </div>
                            </div>
                        </div>
                        <div class="content-desc text-center">
                            <h2 class="loop-product-title"><a href="{{url(session('language').'/shop/category/'.$category->id)}}">{{$category->lang->name}} </a></h2>

                        </div>
                    </div>
                </div>
                @endforeach


            </div>
        </div>
    </div>
    <!--Shop part end-->
@endsection