@extends('front.layout.master')
@section('content')

    <!-- Banner Start -->
    <div class="rs-breadcrumbs img1">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$translations['shop']}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/shop/category/'.$category->main_category_id)}}">{{$category->category?$category->category->lang->name:''}}</a></span>
                    <span class="post">{{$category->lang->name}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!--Shop part start-->
    <div class="rs-shop-part pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row align-items-center rs-vertical-middle shorting mb-50 md-mb-30">


            </div>
            <div class="row">
                @foreach($products as $product)
                <div class="col-lg-4 col-md-6 mb-80 md-mb-40">
                    <div class="product-list">
                        <div class="image-product">
                            <a  href="{{url(session('language').'/products/show/'.$product->id)}}"> <img  class="miages-size-shop" src="{{$product->image}}" alt=""></a>
                            <div class="overley">
                                <div class="product-info">
                                    <a href="{{url(session('language').'/products/show/'.$product->id)}}">{{$translations['read_more']}}</a>
                                </div>
                            </div>
                        </div>
                        <div class="content-desc text-center">
                            <h2 class="loop-product-title"><a href="{{url(session('language').'/products/show/'.$product->id)}}">{{$product->lang->title}} </a></h2>
                            <span class="price">{{$product->price}}</span>
                        </div>
                    </div>
                </div>
                @endforeach
                <div class="col-lg-12 text-center pt-40">
                    <ul class="pagination-part">
                        <li class="active"><a href="#">1</a></li>
                        <li><a href="#">2</a></li>
                        <li><a class="next-page" href="#">Next</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!--Shop part end-->
@endsection