@extends('front.layout.master')
@section('title',$translations['services'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')

    <div class="rs-breadcrumbs img2">
    <div class="container">
        <div class="breadcrumbs-inner">
            <h1 class="page-title">{{$translations['services']}}</h1>
            <div class="breadcrumbs-title">
                <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                <span class="post">{{$translations['services']}}</span>
            </div>
        </div>
    </div>
</div>
<!-- Banner End -->

<!-- Services Section Start -->
<div class="rs-services services-main-home gray-bg pt-120 pb-120 md-pt-80 md-pb-80">
    <div class="container">
        <div class="row">
            @foreach($services as $service)
            <div class="col-xl-4 col-md-6 mb-30">
                <div class="services-item">
                    <div class="services-wrap">
                        <div class="services-image">

                            <a href="{{url(session('language').'/services/show/'.$service->id)}}">
                                <img class="services-image1" src="{{$service->image}}" alt="{{$service->lang->title}}"></a>

                        </div>
                        <div class="services-content">
                            <div class="service-inner">

                                <div class="services-titles">
                                    <h3 class="title"><a href="{{url(session('language').'/services/show/'.$service->id)}}">{{$service->lang->title}}</a></h3>
                                </div>
                                <p class="services-txt">{{$service->lang->sub_title}}</p>
                                <div class="services-btn">
                                    <a class="btn-text" href="{{url(session('language').'/services/show/'.$service->id)}}">{{$translations['read_more']}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection