@extends('front.layout.master')
@section('title',$translations['get_started'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')
    <!--Full width header End-->
    <!-- Breadcrumbs Start -->
    <div class="rs-breadcrumbs img2">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$translations['get_started']}} </h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span class="post">{{$translations['get_started']}} </span>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumbs End -->

    <!-- Appointment Start -->
    <div class="rs-appointment pt-150 pb-115 md-pt-110 md-pb-75">
        <div class="container">
            @if(is_object($section))
            <div class="row">
                <div class="col-lg-6">
                    <div class="title-part">
                        <h2 class="title">{{$section->lang->title}} </h2>
                    </div>
                </div>
                <div class="col-lg-6">
                    <p class="desc-part">{{$section->lang->description}}</p>
                </div>
            </div>
            @endif
            <div class="border-divider">
                <div class="boder-shape"></div>
            </div>
            <div class="row">
                @foreach($sections as $one)
                <div class="col-lg-4 md-mb-30">
                    <div class="content-part">
                        <h3 class="title">{{$one->lang->title}}</h3>
                        <p class="desc">{{$one->lang->description}}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- Appointment End -->
    <!-- Contact Start -->
    <div class="rs-contact contact-style1 pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row no-gutters">
                <div class="col-lg-5">
                    <div class="con-about">
                        <img src="{{url('assets/front/assets/images/appointment/process.jpg')}}" alt="Images">
                    </div>
                </div>
                <div class="col-lg-7">
                    <!-- Contact Start -->
                    <div class="contact-section">
                        <div class="sec-title mb-28">
                            <span class="sub-text">{{$translations['lets_talk']}}</span>
                            <h2 class="title">
                                {{$translations['project_in_mind']}}
                            </h2>
                        </div>
                        <div class="contact-wrap">
                            <div id="form-messages"></div>
                            @include('front.layout.contact')
                        </div>
                    </div>
                    <!-- Contact End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Contact End -->
    <!-- Partner Start -->
    <div class="rs-partner partner-main-home pt-60 pb-60">
        <div class="container">
            <div class="sec-title text-center mb-45">
                <h2 class="title">{{$translations['some_clients']}}</h2>
            </div>
            <div class="rs-carousel owl-carousel" data-loop="true" data-items="5" data-margin="30" data-autoplay="true" data-hoverpause="true" data-autoplay-timeout="5000" data-smart-speed="800" data-dots="false" data-nav="false" data-nav-speed="false" data-center-mode="false" data-mobile-device="2" data-mobile-device-nav="false" data-mobile-device-dots="false" data-ipad-device="3" data-ipad-device-nav="false" data-ipad-device-dots="false" data-ipad-device2="3" data-ipad-device-nav2="false" data-ipad-device-dots2="false" data-md-device="5" data-md-device-nav="false" data-md-device-dots="false">
                @foreach($collaborators as $collaborator)
                    <div class="grid-figure">
                        <div class="logo-img">
                            <a href="{{$collaborator->link??"javascript:;"}}"><img src="{{$collaborator->image}}" alt="clients"></a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- Partner End -->
@endsection