@extends('front.layout.master')
@section('title',$translations['contact_us'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')

    <!-- Banner Start -->
    <div class="rs-breadcrumbs img4">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$translations['contact_us']}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span class="post">{{$translations['contact_us']}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!-- Contact Section Start -->
    <div class="rs-contact contact-style3 pt-120 md-pt-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 md-mb-60">
                    <div class="contact-box">
                        <div class="sec-title mb-45 md-mb-30">
                            <span class="sub-text sub-text3">{{$translations['contact_details']}}</span>
                            <h2 class="title">{{$translations['contact_get_in_touch']}}</h2>
                        </div>


                        <div class="address-box mb-25">
                            <div class="address-icon">
                                <i class="fa fa-envelope"></i>
                            </div>
                            <div class="address-text">
                                <span class="label">{{$translations['email']}}:</span>
                                <a href="mailto:info@Fantasticeg.com">{{$settings['contact_mail']}}</a>
                            </div>
                        </div>
                        <div class="address-box mb-25">
                            <div class="address-icon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <div class="address-text">
                                <span class="label">{{$translations['phone']}}:</span>
                                <a href="tel:01000506269">{{$settings['phone']}}</a>
                            </div>
                        </div>
                        <div class="address-box">
                            <div class="address-icon">
                                <i class="fa fa-map-marker"></i>
                            </div>
                            <div class="address-text">
                                <span class="label">{{$translations['adress']}}:</span>
                                <div class="desc">{{$translations['address']}}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8 pl-70 md-pl-15">
                    <div class="contact-wrap">
                        <div id="form-messages"></div>
                        @include('front.layout.contact')
                    </div>
                </div>
            </div>
        </div>
        <div class="map-canvas pt-120 md-pt-80">
       {!! $settings['map_link']!!}
        </div>
    </div>
    <!-- Contact Section Start -->
@endsection