@extends('front.layout.master')
@section('title',$translations['clients'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')

    <!-- Breadcrumbs Start -->
    <div class="rs-breadcrumbs img5">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$translations['clients']}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span class="post">{{$translations['clients']}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumbs End -->

    <!-- Partner Start -->
    <div class="rs-partner partner-style2 pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                @foreach(\App\Models\Collaborators::latest('id')->get() as $client)
                <div class="col-lg-3 col-md-6 col-sm-6 mb-20">
                    <div class="iconbox-area">
                        <div class="icon-area">
                            <a href="{{$client->link??'javascript:;'}}"><img src="{{$client->image}}" alt="Partner"></a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- Partner End -->

    <!-- Cta Start -->
    <div class="rs-cta bg9 pt-120 pb-115 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-7">
                    <div class="sec-title md-text-center">
                        <span class="sub-text white-color">{{$translations['become_partner']}}</span>
                        <h2 class="title title2">
                            {{$translations['become_partner_description']}}
                        </h2>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="btn-part mt-45 text-right md-text-center">
                        <a class="readon cta-started" href="{{url(session('language').'/contact_us')}}">{{$translations['get_started']}}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection