@extends('front.layout.master')
@section('title',$career->lang->title)
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')

    <div class="rs-breadcrumbs img3">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$career->lang->title}} </h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span class="post">{{$career->lang->title}} </span>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumbs End -->

    <!-- Careers Single Section Start -->
    <div class="rs-careers-single pt-120 pb-100 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 pr-45 md-pr-15">
                    <div class="career-inner-section">

                        <div class="career-img">
                            <img src="{{$career->image}}" alt="{{$career->lang->title}}">
                        </div>

                    {!! $career->lang->description!!}

                        <!-- Contact Start -->
                        <div class="contact-section mt-5">
                            <div class="sec-title mb-28">
                                <span class="sub-text sub-text2"> {{$translations['how_to_apply']}}</span>
                                <h2 class="title title3">

                                    {{$translations['submit_cv']}}
                                </h2>
                            </div>
                            <div class="contact-wrap">
                                <div id="form-messages">
                                    @errors
                                </div>
                                <form method="post" action="{{url('submit-cv')}}" enctype="multipart/form-data">
                                    <fieldset>
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="text" id="name" name="name" placeholder="{{$translations['name']}}" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="text" id="email" name="email" placeholder="{{$translations['email']}}" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="number" id="yearsOfExperience" name="years" placeholder="{{$translations['years_of_experience']}}" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="text" id="phone" name="phone" placeholder="{{$translations['phone']}}" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="number" id="Age" name="age" placeholder="{{$translations['age']}}" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <input class="from-control" type="text" id="JobTitle" name="job_title" placeholder="{{$translations['job_title']}}" required="">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 mb-25">
                                                <label for="file">{{$translations['attach_file']}}: </label>
                                                <input class="file form-control mt-3" type="file" id="file" name="cv" required="">
                                            </div>
                                        </div>
                                        <div class="btn-part mt-3">
                                            <div class="form-group mb-0">
                                                <input class="readon details form-submit" type="submit" value="{{$translations['submit_cv']}}">
                                            </div>
                                        </div>
                                    </fieldset>
                                </form>
                            </div>
                        </div>

                        <!-- Contact End -->
                    </div>
                </div>
                <div class="col-lg-4">

                    <div class="services-add">
                        <div class="address-wrap mb-35">
                            <div class="icon-part">
                                <i class="fa fa-phone"></i>
                            </div>
                        </div>
                        <h2 class="title">{{$translations['Have_any_questions']}}</h2>
                        <div class="contact">
                            <a href="tel:{{$settings['mobile']}}">{{$settings['mobile']}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection