@extends('front.layout.master')
@section('title',$translations['about_us'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')
    <!-- Banner Start -->
    <div class="rs-breadcrumbs img1">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$translations['about_us']}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url('/')}}">{{$translations['home']}}</a></span>
                    <span class="post">{{$translations['about_us']}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!-- About Choose Start -->
    <div class="rs-about about-style1 pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row y-middle">
                <div class="col-lg-6 md-mb-50">
                    <div class="images-part">
                        <img src="{{$about->image}}" alt="About">
                    </div>
                </div>
                <div class="col-lg-6 pl-40 md-pl-15">
                    <div class="sec-title mb-40 md-mb-25">
                        <span class="sub-text">{{$translations['about_us']}}</span>


                        <h2 class="title pb-25">
                          {{$about->lang->title}}
                        </h2>
                        <p class="desc">
                       {!! $about->lang->description !!}</p>

                    </div>
                    <div class="rs-addon-services">
                        <div class="row hover-effect">
                            <div class="col-lg-6 col-md-6 sm-mb-30">
                                <div class="services-item active">
                                    <div class="services-wrap">
                                        <div class="services-icon">
                                            <img src="{{url('assets/front/assets/images/about/style1/icons/1.png')}}" alt="">
                                        </div>
                                        <div class="services-content">
                                            <h3 class="title"> {{$translations['best_prices']}}</h3>
                                            <p class="services-txt">  {{$translations['best_prices_description']}}/p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="services-item">
                                    <div class="services-wrap">
                                        <div class="services-icon">
                                            <img src="{{url('assets/front/assets/images/about/style1/icons/2.png')}}" alt="">
                                        </div>
                                        <div class="services-content">
                                            <h3 class="title">{{$translations['experities']}}</h3>
                                            <p class="services-txt">{{$translations['experities_description']}}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- About Choose End -->

    <!-- Cta Start -->
    <div class="rs-cta bg5 pt-86 pb-86">
        <div class="container">
            <div class="row y-middle">
                <div class="col-lg-8 md-mb-30">
                    <div class="sec-title">
                        <h2 class="title title2">
                            {{$translations['protect_home']}}
                        </h2>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="btn-part text-right md-left">
                        <a class="readon cta-started call-us" href="{{url(session('language').'/contact_us')}}">{{$translations['call_us']}}:{{$setting['phone']}}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Cta End -->

    <!-- Team Start
    <div class="rs-team team-style2 gray-bg pt-120 pb-115 md-pt-80 md-pb-75">
        <div class="container">
            <div class="sec-title text-center mb-40 md-mb-25">
                <span class="sub-text">Expert People</span>
                <h2 class="title">
                    Access Control Heroes
                </h2>
            </div>
            <div class="rs-carousel owl-carousel" data-loop="true" data-items="4" data-margin="30" data-autoplay="true" data-hoverpause="true" data-autoplay-timeout="5000" data-smart-speed="800" data-dots="false" data-nav="false" data-nav-speed="false" data-center-mode="false" data-mobile-device="1" data-mobile-device-nav="false" data-mobile-device-dots="false" data-ipad-device="2" data-ipad-device-nav="false" data-ipad-device-dots="true" data-ipad-device2="2" data-ipad-device-nav2="false" data-ipad-device-dots2="true" data-md-device="4" data-md-device-nav="false" data-md-device-dots="true">
                <div class="team-inner-wrap">
                    <div class="image-wrap">
                        <a href="team-single.html"><img src="assets/images/team/1.jpg" alt="Team"></a>
                    </div>
                    <div class="team-content">
                        <h3 class="team-name"><a href="team-single.html">Koile lavendra</a></h3>
                        <span class="team-title">President & CEO</span>
                        <ul class="social-icons">
                            <li>
                                <a href="#" target="_blank"><span><i class="fa fa-facebook"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-instagram"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-twitter"></i></span></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="team-inner-wrap">
                    <div class="image-wrap">
                        <a href="team-single.html"><img src="assets/images/team/2.jpg" alt="Team"></a>
                    </div>
                    <div class="team-content">
                        <h3 class="team-name"><a href="team-single.html">Alone Mbapy</a></h3>
                        <span class="team-title">Senior Consultant</span>
                        <ul class="social-icons">
                            <li>
                                <a href="#" target="_blank"><span><i class="fa fa-facebook"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-instagram"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-twitter"></i></span></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="team-inner-wrap">
                    <div class="image-wrap">
                        <a href="team-single.html"><img src="assets/images/team/3.jpg" alt="Team"></a>
                    </div>
                    <div class="team-content">
                        <h3 class="team-name"><a href="team-single.html">Shone Watpren</a></h3>
                        <span class="team-title">Finance Consultant</span>
                        <ul class="social-icons">
                            <li>
                                <a href="#" target="_blank"><span><i class="fa fa-facebook"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-instagram"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-twitter"></i></span></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="team-inner-wrap">
                    <div class="image-wrap">
                        <a href="team-single.html"><img src="assets/images/team/4.jpg" alt="Team"></a>
                    </div>
                    <div class="team-content">
                        <h3 class="team-name"><a href="team-single.html">Groze Millard</a></h3>
                        <span class="team-title">IT Consultant</span>
                        <ul class="social-icons">
                            <li>
                                <a href="#" target="_blank"><span><i class="fa fa-facebook"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-instagram"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-twitter"></i></span></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="team-inner-wrap">
                    <div class="image-wrap">
                        <a href="team-single.html"><img src="assets/images/team/5.jpg" alt="Team"></a>
                    </div>
                    <div class="team-content">
                        <h3 class="team-name"><a href="team-single.html">Thomas Omazan</a></h3>
                        <span class="team-title">President & CEO</span>
                        <ul class="social-icons">
                            <li>
                                <a href="#" target="_blank"><span><i class="fa fa-facebook"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-instagram"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-twitter"></i></span></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="team-inner-wrap">
                    <div class="image-wrap">
                        <a href="team-single.html"><img src="assets/images/team/6.jpg" alt="Team"></a>
                    </div>
                    <div class="team-content">
                        <h3 class="team-name"><a href="team-single.html">Shannon Garcia</a></h3>
                        <span class="team-title">Business Advisor</span>
                        <ul class="social-icons">
                            <li>
                                <a href="#" target="_blank"><span><i class="fa fa-facebook"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-instagram"></i></span></a>
                            </li>
                            <li>
                                <a href="# " target="_blank"><span><i class="fa fa-twitter"></i></span></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Team End -->

    <!-- Contact Start -->
    <div class="rs-contact contact-style1 pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row no-gutters">
                <div class="col-lg-5">
                    <div class="con-about">
                        <img src="{{url('assets/front/assets/images/appointment/process.jpg')}}" alt="Images">
                    </div>
                </div>
                <div class="col-lg-7">
                    <!-- Contact Start -->
                    <div class="contact-section">
                        <div class="sec-title mb-28">
                            <span class="sub-text">{{$translations['lets_talk']}}</span>
                            <h2 class="title">
                               {{$translations['project_in_mind']}}
                            </h2>
                        </div>
                        <div class="contact-wrap">
                            <div id="form-messages"></div>
                            @include('front.layout.contact')
                        </div>
                    </div>
                    <!-- Contact End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Contact End -->

    <!-- Partner Start -->
    <div class="rs-partner partner-main-home pt-60 pb-60">
        <div class="container">
            <div class="sec-title text-center mb-45">
                <h2 class="title">{{$translations['some_clients']}}</h2>
            </div>
            <div class="rs-carousel owl-carousel" data-loop="true" data-items="5" data-margin="30" data-autoplay="true" data-hoverpause="true" data-autoplay-timeout="5000" data-smart-speed="800" data-dots="false" data-nav="false" data-nav-speed="false" data-center-mode="false" data-mobile-device="2" data-mobile-device-nav="false" data-mobile-device-dots="false" data-ipad-device="3" data-ipad-device-nav="false" data-ipad-device-dots="false" data-ipad-device2="3" data-ipad-device-nav2="false" data-ipad-device-dots2="false" data-md-device="5" data-md-device-nav="false" data-md-device-dots="false">
                @foreach($collaborators as $collaborator)
                    <div class="grid-figure">
                        <div class="logo-img">
                            <a href="{{$collaborator->link??'javascript:;'}}"><img src="{{$collaborator->image}}" alt="clients"></a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- Partner End -->
@endsection