@extends('front.layout.master')
@section('title',$translations['newest_offers'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')
    <!-- Banner Start -->
    <div class="rs-breadcrumbs img2">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title"> {{$translations['newest_offers']}} </h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span class="post"> {{$translations['newest_offers']}} </span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!-- Project Section Start -->
    <div class="rs-project project-style4 pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                @foreach($offers as $offer)
                <div class="col-lg-4 col-md-6 mb-30">
                    <div class="project-item">
                        <div class="project-img">

                            <a href="{{url(session('language').'/offers/show/'.$offer->id)}}"> <img src="{{$offer->image}}" alt=""></a>
                        </div>
                        <div class="project-content">

                            <h3 class="title"><a href="{{url(session('language').'/offers/show/'.$offer->id)}}">{{$offer->lang->title}}</a></h3>
                            <p class="category"><a href="{{url(session('language').'/offers/show/'.$offer->id)}}">{{$translations['read_more']}}</a></p>
                        </div>
                    </div>
                </div>
                @endforeach
                @if($offers->lastPage()>1)
                    <div class="col-lg-12 text-center pt-40">
                        <ul class="pagination-part">
                            @for($i=1;$i<=$offers->lastPage();$i++)
                                <li class="{{$i==$offers->currentPage()?'active':''}}"><a href="{{url()->current().'?page='.$i}}">{{$i}}</a></li>
                            @endfor
                            @if($offers->lastPage()>1&&$offers->currentPage()<$offers->lastPage())
                                <?php $next= $offers->currentPage()+1;?>
                                <li><a class="next-page" href="{{url()->current().'?page='.$next}}">{{$translations['next']}}</a></li>
                            @endif
                        </ul>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <!-- Project Section End -->

@endsection