@extends('front.layout.master')
@section('title',$gallary->lang->name)
@section('meta')
    <meta name="description" content="{{$gallary->lang->meta_description}}">
    <meta name="keywords" content="{{$gallary->lang->meta_keywords}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')

    <!-- Banner Start -->
    <div class="rs-breadcrumbs img3">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$gallary->lang->name}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span><a title="" href="{{url(session('language').'/gallary')}}">{{$translations['gallary']}}</a></span>
                    <span class="post">{{$gallary->lang->name}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->


    <!-- Gallery Start -->
    <div class="rs-gallery gallery-style1 pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6 mb-30">
                    <div class="gallery-item">
                        <div class="gallery-icon">
                            <a class="image-popup" href="{{$gallary->image}}">
                                <img class="project-img0" src="{{$gallary->image}}" alt=""></a>
                        </div>
                    </div>
                </div>
                @foreach($gallary->images as $image)

                    <div class="col-lg-4 col-md-6 mb-30">
                    <div class="gallery-item">
                        <div class="gallery-icon">
                            <a class="image-popup" href="{{$image->image}}">
                                <img class="project-img0" src="{{$image->image}}" alt=""></a>
                        </div>
                    </div>
                </div>
                @endforeach

            </div>
        </div>
    </div>
    <!-- Gallery End -->

@endsection