@extends('front.layout.master')
@section('title',$translations['gallary'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')
    <div class="rs-breadcrumbs img1">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$translations['gallary']}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span class="post">{{$translations['gallary']}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!-- Project Section Start -->
    <div class="rs-project project-style3 pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                @foreach($gallaries as $gallary)
                <div class="col-lg-4 col-md-6 mb-30">
                    <div class="project-item">
                        <div class="project-img">
                            <img class="project-img0" src="{{$gallary->image}}" alt="images">
                        </div>
                        <div class="project-content">
                            <div class="p-icon"><a href="{{url(session('language').'/gallary/show/'.$gallary->id)}}"><i class="fa fa-arrow-right"></i></a></div>
                            <div class="project-inner">

                                <span class="category"><a href="{{url(session('language').'/gallary/show/'.$gallary->id)}}">{{$gallary->lang->name}}</a></span>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach

                    @if($gallaries->lastPage()>1)
                        <div class="col-lg-12 text-center pt-40">
                            <ul class="pagination-part">
                                @for($i=1;$i<=$gallaries->lastPage();$i++)
                                    <li class="{{$i==$gallaries->currentPage()?'active':''}}"><a href="{{url()->current().'?page='.$i}}">{{$i}}</a></li>
                                @endfor
                                @if($gallaries->lastPage()>1&&$gallaries->currentPage()<$gallaries->lastPage())
                                    <?php $next= $gallaries->currentPage()+1;?>
                                    <li><a class="next-page" href="{{url()->current().'?page='.$next}}">{{$translations['next']}}</a></li>
                                @endif
                            </ul>
                        </div>
                    @endif
            </div>
        </div>
    </div>
    <!-- Project Section End -->
@endsection