@extends('front.layout.master')
@section('title',$news->lang->title)
@section('meta')
    <meta name="description" content="{{$news->lang->meta_description}}">
    <meta name="keywords" content="{{$news->lang->meta_keywords}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')
    <!-- Banner Start -->
    <div class="rs-breadcrumbs img2">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$news->lang->title}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/blog')}}">{{$translations['blog']}}</a></span>
                    <span class="post">{{$news->lang->title}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!-- Blog Section Start -->
    <div class="rs-inner-blog pt-120 pb-120 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 md-mb-50">
                    <div class="blog-details">
                        <div class="blog-full">
                            <div class="bs-img">
                                <img src="{{$news->image}}" alt="Blog">
                            </div>
                            <div class="blog-content-full">
                          {!! $news->lang->description !!}
                            </div>
                            <div class="addthis_inline_share_toolbox"></div>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-12 pl-25 md-pl-15">
                    <div class="widget-area">
{{--                        <div class="search-widget mb-50">--}}
{{--                            <div class="search-wrap">--}}
{{--                                <input type="search" placeholder="Searching..." name="s" class="search-input" value="">--}}
{{--                                <button type="submit" value="Search"><i class="flaticon-search"></i></button>--}}
{{--                            </div>--}}
{{--                        </div>--}}
                        <div class="recent-posts mb-50">
                            <div class="widget-title">
                                <h3 class="title">{{$translations['recent_posts']}}</h3>
                            </div>
                            @foreach($recent_news as $key=>$one)
                            <div class="recent-post-widget {{$key==0?'no-border':''}}">
                                <div class="post-img">
                                    <a href="{{url(session('language').'/blogs/show/'.$one->id)}}"><img src="{{$one->image}}" alt=""></a>
                                </div>
                                <div class="post-desc">
                                    <a href="{{url(session('language').'/blogs/show/'.$one->id)}}">{{$one->lang->title}}</a>

                                </div>
                            </div>
                            @endforeach
                        </div>
                        <!-- Tags
                        <div class="tags-cloud">
                            <div class="widget-title pb-23">
                                <h3 class="title">Tags</h3>
                            </div>
                            <div class="tagcloud">
                                <a href="#">Audit</a>
                                <a href="#">Consulting</a>
                                <a href="#">Credit</a>
                                <a href="#">Repair</a>
                                <a href="#">Solve</a>
                            </div>
                        </div>
                        -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Blog Section End -->
@endsection
@push('js')
    <script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-575dcdc185835a9f"></script>

@endpush