@extends('front.layout.master')
@section('title',$translations['blog'])
@section('meta')
    <meta name="description" content="{{$translations['meta_description']}}">
    <meta name="keywords" content="{{$translations['meta_keywords']}}">
    <meta name="author" content="{{$translations['website']}}"/>
@endsection
@section('content')
    <!-- Banner Start -->
    <div class="rs-breadcrumbs img1">
        <div class="container">
            <div class="breadcrumbs-inner">
                <h1 class="page-title">{{$translations['blog']}}</h1>
                <div class="breadcrumbs-title">
                    <span><a title="Go to Total Technology Website" href="{{url(session('language').'/')}}">{{$translations['home']}}</a></span>
                    <span class="post">{{$translations['blog']}}</span>
                </div>
            </div>
        </div>
    </div>
    <!-- Banner End -->

    <!-- Blog Section Start -->
    <div class="rs-inner-blog pt-120 pb-110 md-pt-80 md-pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 md-mb-50">
                    <div class="row">
                        @foreach($news as $one)
                        <div class="col-lg-12 mb-50">
                            <div class="blog-item">
                                <div class="blog-img" class="blog-img0" >
                                    <a href="{{url(session('language').'/blogs/show/'.$one->id)}}"><img  src="{{$one->image}}" alt=""></a>
                                </div>
                                <div class="blog-content">
                                    <h3 class="blog-title"><a href="{{url(session('language').'/blogs/show/'.$one->id)}}">{{$one->lang->title}}</a></h3>
                                    <div class="blog-meta">

                                    </div>
                                    <div class="blog-desc">
                                   {{$one->lang->sub_description}}
                                    </div>
                                    <div class="blog-button inner-btn">
                                        <a class="blog-btn" href="{{url(session('language').'/blogs/show/'.$one->id)}}">{{$translations['read_more']}}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                <div class="col-lg-4 col-md-12 pl-25 md-pl-15">
                    <div class="widget-area">
{{--                        <div class="search-widget mb-50">--}}
{{--                            <div class="search-wrap">--}}
{{--                                <input type="search" placeholder="Searching..." name="s" class="search-input" value="">--}}
{{--                                <button type="submit" value="Search"><i class="flaticon-search"></i></button>--}}
{{--                            </div>--}}
{{--                        </div>--}}
                        <div class="recent-posts mb-50">
                            <div class="widget-title">
                                <h3 class="title">{{$translations['services']}}</h3>
                            </div>
                            @foreach($services as $key=>$service)
                            <div class="recent-post-widget {{$key==0?'no-border':''}}">
                                <div class="post-img">
                                    <a href="{{url(session('language').'/services/show/'.$service->id)}}"><img src="{{$service->image}}" alt=""></a>
                                </div>
                                <div class="post-desc">
                                    <a href="{{url(session('language').'/services/show/'.$service->id)}}">{{$service->lang->title}}</a>

                                </div>
                            </div>
                            @endforeach
                        </div>


                    </div>
                </div>
                @if($news->lastPage()>1)
                    <div class="col-lg-12 text-center pt-40">
                        <ul class="pagination-part">
                            @for($i=1;$i<=$news->lastPage();$i++)
                                <li class="{{$i==$news->currentPage()?'active':''}}"><a href="{{url()->current().'?page='.$i}}">{{$i}}</a></li>
                            @endfor
                            @if($news->lastPage()>1&&$news->currentPage()<$gallaries->lastPage())
                                <?php $next= $news->currentPage()+1;?>
                                <li><a class="next-page" href="{{url()->current().'?page='.$next}}">{{$translations['next']}}</a></li>
                            @endif
                        </ul>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <!-- Blog Section End -->

@endsection