@extends(config('cms-settings.extends'))
@section('content')
@include('backend.message')
<?php $cms_setting_types=config('cms-settings.types'); ?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">{{trans('cms-settings.create-'.$cms_setting_types[$setting->type])}}</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Home</a>
                    </li>
                    <li class="breadcrumb-item"><a href="{{url('backend/options')}}">Settings</a>
                    </li>
                    <li class="breadcrumb-item">{{trans('cms-settings.update')}}{{$setting->key}}
                    </li>

                </ol>
            </div>
        </div>
    </div>

</div>
<div class="content-body"><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Settings Data</h4>


                </div>

                <div class="card-content collapse show">
                    @if(\Session::get('errors')!==null)


                    <div class="alert alert-danger">
                        {{\Session::get('errors')}}
                    </div>

                    @endif
                    @if(\Session::get('success')!==null)


                    <div class="alert alert-success">
                        {{\Session::get('success')}}
                    </div>

                    @endif
                    <div class="card-body">
                    <form class="form-horizontal" role="form" method="post">
                     <div class="form-body">
                        <div class="form-group">
                            <label class="col-md-2 control-label">{{$setting->key}}</label>
                             @if($setting->type==1)
                                  <?= ImageManager::selector('value[]', [$setting->value], false) ?>    </div>
                                @elseif($setting->type==2)
                                <input type="text" class="form-control" name="value" value="{{$setting->value}}" placeholder="" >
                                @else
                                <textarea name="value" class="form-control" placeholder="" required="">{{$setting->value}}</textarea>
                                @endif
                        </div>
                    
                    
                        {{ csrf_field() }}
                         <div class="form-actions">
                        <div class="form-group">
                                    <input type="submit" name="save" class="btn btn-outline btn-primary" value="Save Changes" />
                                </div>
                            </div>
                        </form>
 </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php
\Session::forget('errors');
\Session::forget('success');
?>
@endsection