@extends('backend.layout')
@section('title',' Setting')
@section('content')
<?php 
use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">Settings Data</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                     <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}"> Dashboard</a>
                    </li>
                    
                    <li class="breadcrumb-item"> Setting
                    </li>

                </ol>
            </div>
        </div>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <div class="media width-250 float-right">
                <div class="input-group-btn">
                <button type="button" class="btn waves-effect waves-light btn-primary dropdown-toggle" data-toggle="dropdown" style="overflow: hidden; position: relative;" aria-expanded="true">{{trans('cms-settings.create-setting')}} <span class="caret"></span></button>
                <ul class="dropdown-menu">
                    <li><a href="{{url(config('cms-settings.prefix').'/settings/create/1')}}">{{trans('cms-settings.create-image')}} </a></li>
                    <li><a href="{{url(config('cms-settings.prefix').'/settings/create/2')}}">{{trans('cms-settings.create-text')}} </a></li>
                    <li><a href="{{url(config('cms-settings.prefix').'/settings/create/3')}}">{{trans('cms-settings.create-area')}} </a></li>
                </ul>
            </div>    </div>
    </div>
</div>

<div class="content-body" ><!-- Default styling start -->

                    @if(\Session::get('errors')!==null)


                    <div class="alert alert-danger">
                        {{\Session::get('errors')}}
                    </div>

                    @endif
                    @if(\Session::get('success')!==null)


                    <div class="alert alert-success">
                        {{\Session::get('success')}}
                    </div>

                    @endif
    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling"  style="">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Settings Data</h4>


                </div>
                <div class="card-content collapse show">

                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                       <th>Key</th>
                                        <th>Value</th>
                                        <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                 @foreach($settings as $key=>$setting)
                                 
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{$setting->key}}</td>
                                        <td style="max-width: 380px;">{!!$setting->settingValue!!}</td>

                                        <td><a href="{{url(config('cms-settings.prefix').'/settings/update/'.$setting->id)}}" class=" btn btn-xs btn-outline btn-success" ><i class="glyphicon glyphicon-pencil"></i> {{trans('cms-backend-auth.update')}}</a>
                                        </td>
                                    </tr>
                                    @endforeach
                            </tbody>
                        </table>

                    </div>

                </div>
            </div>
        </div>
    </div>


</div>
<?php
\Session::forget('errors');
\Session::forget('success');
?>
@stop()