@extends('backend.layout')
@section('title','Add new Settings')
@section('content')
@include('backend.message')
<?php $cms_setting_types=config('cms-settings.types'); ?>

<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0"> Settings</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}"> Dashboard</a>
                    </li>
                    <li class="breadcrumb-item"><a href="{{url('backend/settings')}}"> Settings</a>
                    </li>
                    <li class="breadcrumb-item">Add new
                    </li>

                </ol>
            </div>
        </div>
    </div>

</div>
<div class="content-body"><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"> Settings</h4>


                </div>

                <div class="card-content collapse show">
                    @if(\Session::get('errors')!==null)


                    <div class="alert alert-danger">
                        {{\Session::get('errors')}}
                    </div>

                    @endif
                    @if(\Session::get('success')!==null)


                    <div class="alert alert-success">
                        {{\Session::get('success')}}
                    </div>

                    @endif
                    <div class="card-body">
                        <form method="post" class="form-horizontal" id="form">
                            <div class="form-body">
                                @csrf
                                <div class="form-group">
                                    <div class="col-sm-12">
                                        <label class="control-label">key</label>

                                        <input type="text" class="form-control" name="key" placeholder="{{trans('cms-settings.enter-'.$cms_setting_types[$type].'-key')}}" required="">

                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="col-sm-12">

                                        <label class="control-label">Value</label>

                                        @if($type==1)
                                        <?= ImageManager::selector('value[]', [], false) ?>    
                                        @elseif($type==2)
                                        <input type="text" class="form-control" name="value" placeholder="{{trans('cms-settings.enter-'.$cms_setting_types[$type].'-value')}}" required="">
                                        @else
                                        <textarea name="value" class="form-control" placeholder="{{trans('cms-settings.enter-'.$cms_setting_types[$type].'-value')}}" required=""></textarea>
                                        @endif
                                    </div>

                                </div>
                            </div>
                            <div class="form-actions">
                                <div class="form-group">
                                    <input type="submit" name="save" class="btn btn-outline btn-primary" value="Save Changes" />
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>





@stop()