@extends('backend.layout')
@section('title','Videos Data')
@section('content')
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<?php

use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">Videos Data</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Dashboard</a>
                    </li>

                    <li class="breadcrumb-item">Videos Data
                    </li>

                </ol>
            </div>
        </div>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <div class="media width-250 float-right">
            <a  class="btn btn-success round btn-min-width mr-1 mb-1" href="{{url(\URL::Current().'/create')}}">New</a>
        </div>
    </div>
</div>

<div class="content-body" ><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling"  style="">
        <div class="col-12">
            <div class="col-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Videos Data</h4>


                    </div>
                </div>
                </div>
                <div class="col-6">
                    <button type="button" class="btn btn-xs btn-outline btn-primary" data-toggle="modal" data-target="#myModal" id="stepPreview"><i class="ui-icon ui-icon-arrowthick-2-n-s"></i> Reorder Videos</button>
                    <div class="modal inmodal" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content animated bounceInRight" style="    width: 900px;">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                                    <i class="fa fa-laptop modal-icon"></i>
                                    <h4 class="modal-title">Reorder</h4>
                                </div>
                                <div class="modal-body">
                                    <form class="form-body" method="post" action="{{url('backend/videos/order')}}">
                                @csrf
                                        <ul id="sortable">
                                             @foreach($result as $row)
                                             <li class="ui-state-default"><input type="hidden" name="ids[]" value="{{$row->id}}"/><span class="ui-icon ui-icon-arrowthick-2-n-s"></span>{{$row->name}}</li>
                                            @endforeach
                                        </ul>
                                        <button type="submit">Submit</button>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>


            <div class="card-content collapse show">

                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>

                                <th>Course Name</th>
                                <th>Video Name</th>
                                <th>Link</th>
                                <th>file</th>



                                <th>Settings</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($result as $row)


                        <td>@if($row->course){{$row->course->name}} @endif</td>
                        <td>{{$row->name}}</td>
                        <td>{{$row->link}}</td>
                        <td>@if($row->file) <a href="{{url($row->file)}}" download="" class="btn btn-primary" >Download</a> @endif</td>
                        <td>


                            <a href="{{url('backend/videos/edit/'.$row->id)}}" class=" btn btn-xs btn-outline btn-warning" id="stepEdit"><i class="fa fa-hand-peace"></i>Update</a>


                            {!!Themes::deleteRow($row->id, url('backend/videos/delete'),'')!!}
                        </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>

                </div>
                <?php
                $search_query = \Illuminate\Support\Facades\Input::except('page');
                $result->appends($search_query);
                ?>
                {!! $result->links()!!}

            </div>
        </div>
    </div>
</div>


</div>
<style>
    #sortable{
     
  columns: 4;
  -webkit-columns: 2;
  -moz-columns: 2;

    }
</style>
@stop()
@section('scripts')
<script>
    $(function () {
        $("#sortable").sortable();
        $("#sortable").disableSelection();
    });
</script>
@endsection