<?php

use App\Http\Controllers\Helpers\Html\Components;
use App\Http\Controllers\Helpers\Functions;

if (!isset($video))
    $video = new \App\Models\Videos ();
?>
<div class="card-content collapse show">
    <div class="card-body">
        <form method="post" class="form-horizontal" id="form" enctype="multipart/form-data">
            <div class="form-body">
                @csrf
                <div class="form-group">
                    <div class="form-group">


                        <div class="row col-md-12">
                            <div class="col-6">
                                <label class="control-label">Name</label>
                                <input type="text" name="name" placeholder="Enter Name" class="form-control required" value="{{Functions::issetPost('name', $video->name)}}" required="">
                            </div>


                            <div class="col-6">

                                <label class="control-label">Clip Id</label>
                                <input type="text" name="link" placeholder="Enter Clip Id" class="form-control required" value="{{Functions::issetPost('link', $video->link)}}" >

                            </div>

                        </div>

                    </div>
                </div>
                <div class="row col-md-12"> 
                    <div class="col-md-6">
                    <label class="control-label">Course</label>

                    <select class="form-control" name="course_id" >
                        <option value="">Select Course</option>
                        @foreach($courses as $course)
                        <optgroup label="{{$course->name}}">
                            @foreach($course->childs as $child)
                        <option value="{{$child->id}}" {{Functions::selectedPost('course_id', $video->course_id, $child->id)}}>{{$child->name}}</option>
                        @endforeach
                        </optgroup>
                        @endforeach
                    </select>
                    </div>
                    <div class="col-md-6">
                        <label class="control-label">File (pdf)</label>
                        <input type="file" class="form-control" name="file" accept="application/pdf"
                    </div>
                    @if($video->file)
                    <a href="{{url($video->file)}}" class="btn btn-warning" download="">Download</a>
                    @endif

                </div>


            </div>
            <div class="form-actions">
                <div class="form-group">
                    <input type="submit" name="save" class="btn btn-outline btn-primary" value="Save Changes" />
                </div>
            </div>
        </form>

        <script>
            $(document).ready(function () {

                $("#form").validate({
                    rules: {
                      
                        slug: {
                            required: true
                        },
                        language_id: {
                            required: true
                        },
                        images: {

                        }


                    }
                });
            });
            $(document).ready(function () {
                $('#option-add').click(function () {
                    var option_html = $('#elements').find('div.option-row');
                    $('.options').append(option_html.html());
                });

                //delete option on click 
                $(document).on('click', '.option-delete', function () {
                    console.log($(this).parent('div.option-row').html());
                    $(this).closest('div.option-row').remove();
                });
            });
        </script>
    </div>
</div>