@extends('backend.layout')
@section('title','Users Data')
@section('content')
@include('backend.message')
<?php

use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">Courses Data</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Dashboard</a>
                    </li>

                    <li class="breadcrumb-item">Users Data
                    </li>

                </ol>
            </div>
        </div>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <div class="media width-250 float-right">
            <a  class="btn btn-success round btn-min-width mr-1 mb-1" href="{{url(\URL::Current().'/create')}}">New</a>
        </div>
    </div>
</div>


<form>
    <div class="row">
        <div class="col-md-2">
            <label class="label-control">Serach </label>
        </div>
        <div class="col-md-6">
            <select class="form-control select2" name="user_id">
                <option value="">Select User</option>
                @foreach($all as $user)
                <option value="{{$user->id}}">{{$user->email}}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4">
            <input type="submit" class="btn btn-success" value="Search">
        </div>

    </div>
</form>
<br/>
<div class="content-body" ><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling"  style="">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-2">
                            <h4 class="card-title">Users</h4>
                        </div>
                        <div class="col-md-2">
                            <button id="active" class="btn btn-success" type="button">Active Selected</button>
                        </div>
                        <div class="col-md-2">
                            <button id="deactive" class="btn btn-danger"  type="button">DisActive Selected</button>
                        </div>
                    </div>


                </div>
                <div class="row col-md-12">

                </div>
                <div class="card-content collapse show">

                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id='select_all' />Select All</th>
                                    <th>ID</th>
                                    <th>Name </th>
                                    <th>E-mail</th>
                                    <th>Cohort</th>

                                    <th>Settings</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($result as $row)
                                <tr>


                                    <td><input type="checkbox" name='ids' class="user_id" id='user_id' value='{{$row->id}}'/></td>
                                    <td> {{$row->id}}</td>
                                    <td>{{$row->name}}</td>

                                    <td>{{$row->email}}</td>
                                    <td>{{$row->cohort}}</td>

                                    <td>
                                        <a href="{{url('backend/users/show/'.$row->id)}}" class=" btn btn-xs btn-outline btn-blue-grey"  id="stepEdit"><i class="fa fa-eye"></i> Update CourseList</a>
                                        <a href="{{url('backend/users/showlog/'.$row->id)}}" class=" btn btn-xs btn-outline btn-blue-grey"  id="stepEdit"><i class="fa fa-eye"></i> show Log</a>
                                        <a href="{{url('backend/users/update/'.$row->id)}}" class=" btn btn-xs btn-outline btn-primary"  id="stepEdit"><i class="fa fa-edit"></i> Update</a>
                                        <a href="{{url('backend/users/update-pass/'.$row->id)}}" class=" btn btn-xs btn-outline btn-primary"  id="stepEdit"><i class="fa fa-edit"></i>Update Password</a>
                                        <a href="{{url('backend/users/active/'.$row->id)}}" class=" btn btn-xs btn-outline @if($row->activited==1) btn-danger @else btn-success @endif"  id="stepEdit"><i class="fa fa-edit"></i>@if($row->activited==1) Disactive @else active @endif</a>


                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                    <?php
                    $search_query = \Illuminate\Support\Facades\Input::except('page');
                    $result->appends($search_query);
                    ?>
                    {!! $result->links()!!}

                </div>
            </div>
        </div>
    </div>


</div>

@stop()
@section('scripts')
<script>
    $(document).ready(function () {
    $("#select_all").click(function () {
    $(".user_id").prop('checked', $(this).prop('checked'));
    });
            $('#active').click(function(){
    var ids = [];
            $.each($(".user_id:checked"), function(){
            ids.push($(this).val());
            });
            if (ids.length === 0){
    swal({
    title: "alert",
            text: 'Please Select users',
            type: "error",
            html: true,
            timer: 3000,
            showConfirmButton: true
    });
            return false;
    }
    var text = ids.toString();
            $.ajax({
            url: "<?= url('backend/users/active-slected?ids=') ?>" + text,
                    method: 'GET',
                    success: function (response) {
                    if (response.status === true){
                        location.reload(true); 
                    }


                    }
                    });
            });
            $('#deactive').click(function(){
    var ids = [];
            $.each($(".user_id:checked"), function(){
            ids.push($(this).val());
            });
            if (ids.length === 0){
    swal({
    title: "alert",
            text: 'Please Select users',
            type: "error",
            html: true,
            timer: 3000,
            showConfirmButton: true
    });
            return false;
    }
    var text = ids.toString();
            $.ajax({
            url: "<?= url('backend/users/disactive-slected?ids=') ?>" + text,
                    method: 'GET',
                    success: function (response) {
                    if (response.status === true){
                        location.reload(true); 
                    }


                    }
                    });
            });
            });
</script>
@endsection