@extends('backend.layout')
@section('title','تعديل | المتخصصين')
@section('content')
@include('backend.message')
<div class="row" >
    <div class="col-sm-12" style="float: right;">

        <div class="page-title-box">
            <div class="float-left">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">الرئيسيه</a></li>
                    <li class="breadcrumb-item"><a href="{{url('backend/specialists')}}">المتخصصين</a></li>
                    <li class="breadcrumb-item"><a href="">تعديل متخصص</a></li>

                </ol>
                <!--end breadcrumb-->
            </div>

           
        </div>
    </div>
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <h4 class="mt-0 header-title">تعديل متخصص</h4>
                <form method="post"  id="form">
                    <div class="form-body">
                        @csrf
                        <div class="form-group">
                            <div class="row">

                                <div class="col-6">
                                    <label class="control-label">الاسم</label>
                                    <input type="text" name="name" placeholder="أدخل الأسم" class="form-control required" value="{{$user->name}}"  required="">
                                </div>
                                <div class="col-6">
                                    <label class="control-label">البريد الألكترونى </label>
                                    <input type="email" name="email" value="{{$user->email}}" placeholder="ادخل البريد الألكترونى" class="form-control required"  required="">

                                </div>
                            </div>
                        </div>
                     
                        <div class="form-group">
                            <div class="row">


                                <div class="col-6">
                                    <label class="control-label">التخصص</label>
                                    <select name="category_id" class="form-control" required="">
                                    <option value="">أختار تخصص</option>
                                  @foreach($categories as $category)
                                  <option value="{{$category->id}}" @if($category->id==$user->category_id) selected @endif >{{$category->language->name}}</option>
                                  @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row col-sm-12">
                                <div class="col-6">
                                    <label>الصورة</label>
                                     <?= ImageManager::selector('image[]', [$user->image_id], false) ?>
                                </div>
                                <div class="col-6">
                                    <label>الصور</label>
                                     <?= ImageManager::selector('images[]', $files, true) ?>
                                </div>
                                
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="form-group">
                                <input type="submit" name="save" class="btn btn-outline btn-primary" value="Save" />
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {

        $("#form").validate({
            rules: {
                name: {
                    required: true
                },
                slug: {
                    required: true
                },
                language_id: {
                    required: true
                },
                images: {

                }


            }
        });
    });
</script>
</div>
</form>

</div>
</div>
</div>






@stop()