@extends('backend.layout')
@section('title','انشاء | المتخصصين')
@section('content')
@include('backend.message')
<div class="row" >
    <div class="col-sm-12" style="float: right;">

        <div class="page-title-box">
            <div class="float-left">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">الرئيسيه</a></li>
                    <li class="breadcrumb-item"><a href="">أنشاء متخصص</a></li>

                </ol>
                <!--end breadcrumb-->
            </div>


        </div>
    </div>
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <h4 class="mt-0 header-title">انشاء متخصص</h4>
                <form method="post"  id="form">
                    <div class="form-body">
                        @csrf
                        <div class="form-group">
                            <div class="row">

                                <div class="col-6">
                                    <label class="control-label">الاسم</label>
                                    <input type="text" name="name" placeholder="أدخل الأسم" class="form-control required"  required="">
                                </div>
                                <div class="col-6">
                                    <label class="control-label">البريد الألكترونى </label>
                                    <input type="email" name="email" placeholder="ادخل البريد الألكترونى" class="form-control required"  required="">

                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">

                                <div class="col-6">
                                    <label class="control-label">الرقم السرى</label>
                                    <input type="password" name="password" placeholder="أدخل الرقم السرى" class="form-control required"  required="">
                                </div>
                                <div class="col-6">
                                    <label class="control-label">اعاده الرقم السرى</label>
                                    <input type="password" name="confirm_password" placeholder="أدخل اعاده الرقم السرى" class="form-control required"  >

                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">


                                <div class="col-6">
                                    <label class="control-label">التخصص</label>
                                    <select name="category_id" class="form-control" required="">
                                    <option value="">أختار تخصص</option>
                                  @foreach($categories as $category)
                                  <option value="{{$category->id}}">{{$category->language->name}}</option>
                                  @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row col-sm-12">
                                <div class="col-6">
                                    <label>الصورة</label>
                                     <?= ImageManager::selector('image[]', [], false) ?>
                                </div>
                                <div class="col-6">
                                    <label>الصور</label>
                                     <?= ImageManager::selector('images[]', [], true) ?>
                                </div>
                                
                            </div>
                        </div>
                        
                        

                        <div class="form-actions">
                            <div class="form-group">
                                <input type="submit" name="save" class="btn btn-outline btn-primary" value="Save" />
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div id="elements" style="display: none">
            <div class="row option-row">
                <div class="row option-row">

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">فريق العمل</label>
                            <input type="text" name="doctors[]" value="" placeholder="فريق العمل" class="form-control" />
                        </div>
                    </div>

                    <div class="col-md-2">
                        <br/><br/>
                        <button title="Remove Row" type="button"  class="btn btn-danger option-delete"><i class="fa fa-times-circle"></i></button>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>

<script>
    $(document).ready(function () {

        $("#form").validate({
            rules: {
                name: {
                    required: true
                },
                slug: {
                    required: true
                },
                language_id: {
                    required: true
                },
                images: {

                }


            }
        });
        $('#option-add').click(function () {
            var option_html = $('#elements').find('div.option-row');
            $('.options').append(option_html.html());
        });

        //delete option on click 
        $(document).on('click', '.option-delete', function () {
            console.log($(this).parent('div.option-row').html());
            $(this).closest('div.option-row').remove();
        });
    });
</script>
</div>
</form>

</div>
</div>
</div>






@stop()