<?php

use App\Http\Controllers\Helpers\Html\Components;
use App\Http\Controllers\Helpers\Functions;

if (!isset($secondary_category))
    $secondary_category = new \App\Models\SecondaryCategories();

$x = 12 / count($languages);
?>
<div class="card-content collapse show">
    <div class="card-body">
        <form class="steps-validation wizard-circle" method="post">

            <!-- Step 1 -->
            <h6>common things</h6>
            <fieldset>
                <div class="row">
                       <input type="hidden" value="{{$secondary_category->image_id}}" name="image"/>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control" >
                                Image :</label>
                                <?= Components::uploader($secondary_category->image_id) ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="label-control">Main Category</label>
                        <select class="form-control requiredselect2" name="category_id" required="">
                            <option value="">Select Main Category</option>
                            @foreach($categories as $category)
                            <option value="{{$category->id}}" @if($secondary_category->main_category_id==$category->id) selected @endif>{{$category->language->name}}</option>
                            @endforeach
                        </select>
                    </div>


                </div>
                <hr/>
                    <input type="hidden" value="1" name="save"/>


            </fieldset>

            @foreach($languages as $key=>$lang)
            <!-- Step 2 -->
            <h6>{{$lang->name}}</h6>
            <fieldset>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >{{$lang->name}} Name : *</label>
                            <input type="text" name="name_{{$lang->id}}" @if($secondary_category->langs()->where('language_id',$lang->id)->first()) value='{{$secondary_category->langs()->where('language_id',$lang->id)->first()->name}}' @endif class="form-control required" required="">
                        </div>

                    </div>


{{--                    <div class="col-md-6">--}}
{{--                        <label class="label-control"  >{{$lang->name}} Description : </label>--}}
{{--                        <textarea name="description_{{$lang->id}}" cols="6" rows="6" class="form-control required" required=""> @if($secondary_category->langs()->where('language_id',$lang->id)->first()) {{$secondary_category->langs()->where('language_id',$lang->id)->first()->description}} @endif</textarea>--}}
{{--                    </div>--}}

                </div>
{{--                <div class="row">--}}
{{--                    <div class="col-md-6">--}}
{{--                        <div class="form-group">--}}
{{--                            <label class="label-control"  >{{$lang->name}} meta Title : *</label>--}}
{{--                            <input type="text" name="meta_title_{{$lang->id}}" @if($secondary_category->langs()->where('language_id',$lang->id)->first()) value='{{$secondary_category->langs()->where('language_id',$lang->id)->first()->meta_title}}' @endif class="form-control" >--}}
{{--                        </div>--}}

{{--                    </div>--}}
{{--                    <div class="col-md-6">--}}
{{--                        <div class="form-group">--}}
{{--                            <label class="label-control"  >{{$lang->name}} meta KeyWords : *</label>--}}
{{--                            <input type="text" name="meta_keywords_{{$lang->id}}" @if($secondary_category->langs()->where('language_id',$lang->id)->first()) value='{{$secondary_category->langs()->where('language_id',$lang->id)->first()->meta_keywords}}' @endif class="form-control" >--}}
{{--                        </div>--}}

{{--                    </div>--}}
{{--                </div>--}}
{{--                <div class="row">--}}
{{--                    <div class="col-md-12">--}}
{{--                        <label class="label-control" >{{$lang->name}} Meta Description : </label>--}}
{{--                        <textarea name="meta_description_{{$lang->id}}" cols="6" class="form-control" > @if($secondary_category->langs()->where('language_id',$lang->id)->first()) {{$secondary_category->langs()->where('language_id',$lang->id)->first()->meta_description}} @endif</textarea>--}}

{{--                    </div>--}}
{{--                </div>--}}
                <hr/>
            </fieldset>
            @endforeach
            <!-- Step 3 -->


        </form>
    </div>
    <script>
        $(document).ready(function () {

          @if($secondary_category->exists)
               $('[role=tablist]').find("[role=tab]").removeClass('disabled')
                @endif
                    $("#form").validate({
                rules: {
                    description: {
                        required: true
                    },
                    language_id: {
                        required: true
                    },
                    images: {
                        required: true
                    }


                }
            });
        });
    </script>
</div>
