@extends('backend.layout')
@section('title','Contacts Data')
@section('content')
<?php

use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">Contacts Data</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Home</a>
                    </li>


                    <li class="breadcrumb-item">Contacts
                    </li>

                </ol>
            </div>
        </div>
    </div>

</div>

<div class="content-body" ><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling"  style="">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-6"><h4 class="card-title">Contacts</h4>
                        </div>
                        <div class="col-md-6">
                            <a href="{{url(URL::current().'/download')}}" class="d-inline btn btn-xs btn-primary">Download Sheet </a>          
                                    
                               
                        </div>
                    </div>
                </div>
                <div class="card-content collapse show">

                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Date</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>Address</th>
                                    <th>Email</th>
                                    <th>Company</th>
                                   
                              
                                    <th>Settings</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach($result as $row)
                                <tr>


                                    <td>{{$row->id}}</td>
                                    <td>{{date('Y-m-d',strtotime($row->created_at))}}</td>
                                    <td>{{$row->name}}</td>
                                    <td>{{$row->phone}}</td>
                                    <td>{{$row->country}} - {{$row->town}} </td>
                                    <td>{{$row->email}}</td>
                                    <td>{{$row->company}}</td>
                                    
                                    <td>
                                        <button type="button" class="btn btn-xs btn-outline btn-warning" data-toggle="modal" data-target="#myModal{{$row->id}}" id="stepPreview"><i class="fa fa-twitch"></i> Review</button>
                                        <div class="modal inmodal" id="myModal{{$row->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content animated bounceInRight">
                                                    <div class="modal-header">
                                                        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                                                        <i class="fa fa-laptop modal-icon"></i>
                                                        <h4 class="modal-title">Preview All Data</h4>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                        <div class=" col-md-12">
                                                            <table class="table-bordered">
                                                        <tr>
                                                            <td>ID</td>
                                                            <td>{{$row->id}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Name</td>
                                                            <td>{{$row->name}}</td>
                                                        </tr>
                                                        </table>
                                                        </div>
                                                        <div class=" col-md-12">
                                                        <table class="table-bordered">
                                                        <tr>
                                                            <td>Date</td>
                                                            <td>{{date('Y-m-d',strtotime($row->id))}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Email</td>
                                                            <td>{{$row->email}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Phone</td>
                                                            <td>{{$row->phone}}</td>
                                                        </tr>
                                                        </table>
                                                        </div>
                                                        </div>
                                                        <div class="clearfix"></div>
                                                        <div class="row ">
                                                            <table class="table-bordered">
                                                                <tr>
                                                                    <td>Message</td>
                                                                    <td>{{$row->message}}</td>
                                                                </tr>
                                                              
                                                            </table>
                                                        </div>




                                                   
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
<!--                                        {!!Themes::deleteRow($row->id, url('contacts/delete'),['data-action'=>"options.delete"])!!}-->
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>

                </div>
            </div>
        </div>
    </div>

      <?php  $search_query = \Illuminate\Support\Facades\Input::except('page');
                    $result->appends($search_query); ?>
            {!! $result->links()!!}
                    
</div>

@stop()