<?php

use App\Http\Controllers\Helpers\Html\Components;
use App\Http\Controllers\Helpers\Functions;

if (!isset($menu_link))
    $menu_link = new \App\Models\MenusLinks();

$x = 12 / count($languages);
?>
<div class="card-content collapse show">
    <div class="card-body">
        <form method="post" class="form-horizontal" id="form">
            <div class="form-body">
                @csrf

                <div class="form-group">
                    <div class="row col-sm-12">
                        @foreach ($languages as $language)
                        <div class="col-md-{{$x}}">
                            <label class="control-label">{{$language->name}} Title </label>
                            <input type="text" class="form-control required" name="title_{{$language->id}}" @if($menu_link->langs()->where('language_id',$language->id)->first())  value="{{$menu_link->langs()->where('language_id',$language->id)->first()->title}}" @endif required/>
                        </div>
                        @endforeach
                    </div>
                </div>

                <div class="form-group">
                    <div class="row col-sm-12">
                        <div class="col-sm-4">
                            <label class="control-label">Link</label>
                            <input type="text" name="link" class="form-control required" placeholder="example(/categories)" required="" value="{{$menu_link->link}}"/>
                        </div>
                        <div class="col-sm-4">
                            <label class="control-label">Menu</label>
                            <select class="form-control" disabled="" name="{{$menu->id}}">
                                <option value="{{$menu->id}}">{{$menu->language->title}}</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-actions">
                <div class="form-group">
                    <input type="submit" name="save" class="btn btn-outline btn-primary" value="Save Changes" />
                </div>
            </div>
        </form>


        <script>
            $(document).ready(function () {


            });
        </script>
    </div>
</div>