@extends('backend.layout')
@section('title','Menus Data')
@section('content')
<?php 
use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">Menus Data</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-6">
                <ol class="breadcrumb">
                     <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Home</a>
                    </li>
                    
                    <li class="breadcrumb-item">Menus Data
                    </li>

                </ol>
            </div>
            @if($result->count()>1)
            <div class="col-6">
                    <button type="button" class="btn btn-xs btn-outline btn-primary" data-toggle="modal" data-target="#myModal" id="stepPreview"><i class="ui-icon ui-icon-arrowthick-2-n-s"></i> Reorder Menus</button>
                    <div class="modal inmodal" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content animated bounceInRight" style="    width: 900px;">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                                    <i class="fa fa-laptop modal-icon"></i>
                                    <h4 class="modal-title">Reorder</h4>
                                </div>
                                <div class="modal-body">
                                    <form class="form-body" method="post" action="{{url('backend/menus/order')}}">
                                @csrf
                                        <ul id="sortable">
                                             @foreach($result as $row)
                                             <li class="ui-state-default"><input type="hidden" name="ids[]" value="{{$row->id}}"/><span class="ui-icon ui-icon-arrowthick-2-n-s"></span>{{$row->language->title}}</li>
                                            @endforeach
                                        </ul>
                                <button class="btn btn-success" type="submit">Submit</button>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            @endif
        </div>
    </div>
<!--    <div class="content-header-right col-md-6 col-12">
        <div class="media width-250 float-right">
            <a  class="btn btn-success round btn-min-width mr-1 mb-1" href="{{url(\URL::Current().'/create')}}">Create</a>
        </div>
    </div>-->
</div>

<div class="content-body" ><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling"  style="">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Menus Data</h4>


                </div>
                <div class="card-content collapse show">

                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Icon</th>
                                    <th>Link</th>
                                    
                                    <th>Title</th>
                                  
                                    <th>Settings</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($result as $row)
                                <tr>
                                    <td><i class="{{$row->icon}}"></i></td>
                                    <td>{{$row->link}}</td>
                                  
                                    <td>{{$row->language->title}}</td>
                                    
                                    <td>
                                        <a href="{{url(\URL::Current().'/edit/'.$row->id)}}" class=" btn btn-xs btn-outline btn-primary"  id="stepEdit"><i class="fa fa-paste"></i> Update</a>
                                        <!--<a href="{{url('backend/menus_links/'.$row->id)}}" class=" btn btn-xs btn-outline btn-warning"  id="stepEdit"><i class="fa fa-eye"></i> Show Childs</a>-->
                                      
                                       
                                        <!--{!!Themes::deleteRow($row->id, url(\URL::Current().'/delete'),[])!!}-->
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>

                </div>
            </div>
        </div>
    </div>

<script>
  $(document).ready(function () {
    $( "#sortable" ).sortable();
  });
</script>
<style>
    #sortable {
  columns: 2;
  -webkit-columns: 2;
  -moz-columns: 2;
}
</style>
</div>

@stop()