<?php

use App\Http\Controllers\Helpers\Html\Components;
use App\Http\Controllers\Helpers\Functions;

if (!isset($event))
    $event = new \App\Models\Events();
$x = 12 / count($languages);
?>
<div class="card-content collapse show">
    <div class="card-body">
        <form class="steps-validation wizard-circle" method="post">

            <!-- Step 1 -->
            <h6>common things</h6>
            <fieldset>
                <div class="row">
                    <input type="hidden" value="{{$event->image_id}}" name="image"/>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control" >
                                Image :</label>
                            <?= Components::uploader($event->image_id) ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control">Date</label>
                            <div class="input-group date" >
                                <input type="text" name="start_time" id="datetimepicker1" class="form-control" required="" @if($event->start_time!='') value="{{date('d.m.Y H:i',strtotime($event->start_time))}}" @endif>
                            </div>
                        </div>
                    </div>



                </div>
                
                    <div class="form-group">
                        <label>Map Link</label>
                        <textarea name="map_link" class="form-control" required="">{{$event->map_link}}</textarea>
                    </div>
                

                <input type="hidden" value="1" name="save"/>


            </fieldset>

            @foreach($languages as $key=>$lang)
            <!-- Step 2 -->
            <h6>{{$lang->name}}</h6>
            <fieldset>
                <div class="row col-md-12">
                 
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control">Address : *</label>
                            <input type="text" name="address_{{$lang->id}}" class="form-control required" @if($event->langs()->where('language_id',$lang->id)->first()) value='{{$event->langs()->where('language_id',$lang->id)->first()->address}}' @endif class="form-control required" required="">

                        </div>
                    </div>
                </div>
                <div class="row col-md-12">

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >Name : *</label>
                            <input type="text" name="name_{{$lang->id}}" @if($event->langs()->where('language_id',$lang->id)->first()) value='{{$event->langs()->where('language_id',$lang->id)->first()->name}}' @endif class="form-control required" required="">
                        </div>

                    </div>


                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >Sub Description : </label>
                            <textarea name="sub_description_{{$lang->id}}" cols="6" rows="6" class="form-control required" required=""> @if($event->langs()->where('language_id',$lang->id)->first()) {{$event->langs()->where('language_id',$lang->id)->first()->sub_description}} @endif</textarea>
                        </div>
                    </div>

                </div>
                <hr/>
                <div class="row col-md-12">
                    <div class="form-group">
                        <label class="label-control"  >Description : </label>

                        <textarea name="description_{{$lang->id}}" cols="6" rows="6" class="form-control editor" required=""> @if($event->langs()->where('language_id',$lang->id)->first()) {{$event->langs()->where('language_id',$lang->id)->first()->description}} @endif</textarea>
                    </div>
                </div>
                <hr/>
                <div class="row col-md-12">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >meta Title : *</label>
                            <input type="text" name="meta_title_{{$lang->id}}" @if($event->langs()->where('language_id',$lang->id)->first()) value='{{$event->langs()->where('language_id',$lang->id)->first()->meta_title}}' @endif class="form-control" >
                        </div>

                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >meta KeyWords : *</label>
                            <input type="text" name="meta_keywords_{{$lang->id}}" @if($event->langs()->where('language_id',$lang->id)->first()) value='{{$event->langs()->where('language_id',$lang->id)->first()->meta_keywords}}' @endif class="form-control" >
                        </div>

                    </div>
                </div>
                <hr/>
                <div class="row col-md-12">
                    <div class="col-md-12">
                        <label class="label-control" >Meta Description : </label>
                        <textarea name="meta_description_{{$lang->id}}" cols="6" class="form-control" > @if($event->langs()->where('language_id',$lang->id)->first()) {{$event->langs()->where('language_id',$lang->id)->first()->meta_description}} @endif</textarea>

                    </div>
                </div>
                <hr/>
            </fieldset>
            @endforeach
            <!-- Step 3 -->


        </form>
    </div>
    <script>
        $(document).ready(function () {
$('#datetimepicker1').datetimepicker({
       
      
                    locale: 'en'
                   

                }).datepicker("setDate",'now');

 @if($event->exists)
               $('[role=tablist]').find("[role=tab]").removeClass('disabled')
                @endif
            $("#form").validate({
                rules: {
                    description: {
                        required: true
                    },
                    language_id: {
                        required: true
                    },
                    images: {
                        required: true
                    }


                }
            });
        });
    </script>
</div>
