@extends('backend.layout')
@section('title','Reviews Data')
@section('content')
<?php

use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">Reviews Data</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Home</a>
                    </li>
                    <li class="breadcrumb-item"><a href="{{url('backend/products')}}">Products</a>
                    </li>

                    <li class="breadcrumb-item">التقييمات والتعليقات
                    </li>

                </ol>
            </div>
        </div>
    </div>

</div>

<div class="content-body" ><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling"  style="">
        <div class="col-12">
            <div class="card">
                <div class="card-header">

                    <h4 class="card-title">التقييمات والتعليقات</h4>

                    <div class="row">
                        <div class="col-md-4">
                            <h4 class="card-title">التقييمات والتعليقات</h4>
                        </div>
                        <div class="col-md-4">
                            <h5 class="card-title success">إجمالي التقييمات:<span class="danger">{{$result->total()}}</span></h5>
                        </div>
                        

                    </div>


                </div>

                <div class="col-md-12">
                    <form>
                        <div class="container">
                            <h5><span class="red">{{trans('backend.filter')}}</span></h5>
                            <div class="row">

                                <div class="col-3">
                                    <div class="form-group">
                                        <label class="label-control">معدل التقييم</label>
                                        <select name="rate" class="form-control">
                                            <option value="">{{trans('backend.all')}}</option>
                                            @for($x=1;$x<6;$x++)
                                            <option value="{{$x}}">{{$x}}نجمة</option>
                                            @endfor
                                        </select>
                                    </div> 
                                </div>

                                <div class="col-3">
                                    <div class="form-group">
                                        <label class="label-control">حاله المراجعة</label>
                                        <select class="form-control" name="type">
                                            <option value="">{{trans('backend.all')}}</option>
                                            @foreach(rate_status as $key=>$value)
                                            <option value="{{$key}}">{{$value}}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>

                                <div class="col-3">
                                    <label class="label-control"></label>
                                    <button type="submit" style="margin-top: 22px" class="btn btn-success ">{{trans('backend.search')}}</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>


                <div class="card-content collapse show">

                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>رقم التقييم</th>
                                    <th>التاريخ</th>
                                    <th>ألاسم</th>
                                    <th>المنتج</th>
                                    <th>التقييم</th>
                                    <th>التعليق</th>
                                    <th>الحاله</th>
                                    <th>الاعدادات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($result as $row)
                                <tr>
                                    <td>{{$row->id}}</td>
                                    <td>{{date('Y-M-d',strtotime($row->created_at))}}</td>
                                   
                                    <td><a href="{{url('backend/users/show/'.$row->user->id)}}">{{$row->user->firstname}} {{$row->user->lastname}}</a></td>
                                    <td>{{$row->product->language->name}}</td>
                                    <td>@for($i=1;$i<=$row->rating;$i++)<i class="ft-star"> </i>@endfor</td>
                                    <td>{{str_limit($row->feed_back,30)}}..</td>
                                    <td><span class="btn @if($row->active==1) btn-success @elseif($row->active==2) btn-danger @elseif($row->active==0) btn-warning  @endif" >{{rate_status[$row->active]}}</span></td>


                                    <td>
                                        <button type="button" class="btn btn-xs btn-outline btn-warning" data-toggle="modal" data-target="#myModal{{$row->id}}" id="stepPreview"><i class="fa fa-twitch"></i> مراجعة</button>
                                        <div class="modal inmodal" id="myModal{{$row->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content animated bounceInRight">
                                                    <div class="modal-header">
                                                        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                                                        <i class="fa fa-laptop modal-icon"></i>
                                                        <h4 class="modal-title">Preview All Data</h4>
                                                    </div>
                                                    <div class="modal-body">
                                                        <blockquote>




                                                            <strong style="font-size: 18px;">التعليق</strong> :

                                                            <p>{{$row->feed_back}}</p>
                                                            <form method="post" action="{{url('backend/products/reviews/accept/'.$row->id)}}">
                                                                <div class="form-body">
                                                                    <div class="form-group">
                                                                        <label class="label-control">حاله المراجعه</label>
                                                                        <select name="rate_type" class="form-control" required="">
                                                                            @foreach (rate_status as $key=>$value)
                                                                            <option value="{{$key}}" @if($row->active==$key) selected @endif>{{$value}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                @csrf
                                                                <div class="form-actions">
                                                                    <input class="btn btn-success" type="submit" value="تغيير حاله المراجعة" name="save">
                                                                </div>
                                                            </form>




                                                        </blockquote>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-white" data-dismiss="modal">Close</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        {!!Themes::deleteRow($row->id, url('backend/products/delete-review'),['data-action'=>"options.delete"])!!}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                    <?php $search_query = \Illuminate\Support\Facades\Input::except('page');
                    $result->appends($search_query);
                    ?>
                    {!! $result->links()!!}

                </div>
            </div>
        </div>
    </div>


</div>

@stop()