@extends('backend.layout')
@section('title','Courses Data')
@section('content')
<?php

use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">Courses Data</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Dashboard</a>
                    </li>

                    <li class="breadcrumb-item">Courses Data
                    </li>

                </ol>
            </div>
        </div>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <div class="media width-250 float-right">
            <a  class="btn btn-success round btn-min-width mr-1 mb-1" href="{{url(\URL::Current().'/create')}}">New</a>
        </div>
    </div>
</div>

<div class="content-body" ><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling"  style="">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Courses Data</h4>


                </div>

             
                <div class="card-content collapse show">

                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                  
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Main Course</th>
                                   


                                    <th>Settings</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($result as $row)
                                <tr>
                                    
                                    <td>{{$row->id}}</td>
                                    <td>{{$row->name}}</td>
                                    <td>@if($row->parentcourse) {{$row->parentcourse->name}} @else Main Course @endif</td>
                                 
                                    <td>


                                        <a href="{{url('backend/courses/edit/'.$row->id)}}" class=" btn btn-xs btn-outline btn-warning" id="stepEdit"><i class="fa fa-hand-peace"></i>Update</a>
                                       @if($row->parentcourse) <a href="{{url('backend/videos?course_id='.$row->id)}}" class=" btn btn-xs btn-outline btn-primary" id="stepEdit"><i class="fa fa-eye"></i>Videos</a>
                                       @else
                                       <a href="{{url('backend/courses/'.$row->id)}}" class=" btn btn-xs btn-outline btn-primary" id="stepEdit"><i class="fa fa-eye"></i>Childs Titles</a>
                                       @endif
                                        

                                        {!!Themes::deleteRow($row->id, url('backend/courses/delete'),'')!!}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                    <?php $search_query = \Illuminate\Support\Facades\Input::except('page');
                    $result->appends($search_query);
                    ?>
                    {!! $result->links()!!}

                </div>
            </div>
        </div>
    </div>


</div>

@stop()