<?php

use App\Http\Controllers\Helpers\Html\Components;
use App\Http\Controllers\Helpers\Functions;

if (!isset($course))
    $course = new \App\Models\Courses ();
?>
<div class="card-content collapse show">
    <div class="card-body">
        <form method="post" class="form-horizontal" id="form">
            <div class="form-body">
                @csrf
                <div class="form-group">
                    <div class="form-group">


                        <div class="row col-md-12">
                            <div class="col-6">
                                <label class="control-label">Name</label>
                                <input type="text" name="name" placeholder="Enter Name" class="form-control required" value="{{Functions::issetPost('name', $course->name)}}" required="">
                            </div>
                            <div class="col-6">
                                <label class="control-label">Main Course</label>

                                <select class="form-control" name="parent_id" >
                                    <option value="">Main Course</option>
                                    @foreach($parents as $parent)
                                    <option value="{{$parent->id}}" {{Functions::selectedPost('parent_id', $course->parent_id, $parent->id)}}>{{$parent->name}}</option>
                                    @endforeach
                                </select>



                            </div>

                        </div>
                    </div>


                </div>
                <div class="form-actions">
                    <div class="form-group">
                        <input type="submit" name="save" class="btn btn-outline btn-primary" value="Save Changes" />
                    </div>
                </div>
        </form>

        <script>
            $(document).ready(function () {

                $("#form").validate({
                    rules: {
                        name: {
                            required: true
                        },
                        slug: {
                            required: true
                        },
                        language_id: {
                            required: true
                        },
                        images: {

                        }


                    }
                });
            });
            $(document).ready(function () {
                $('#option-add').click(function () {
                    var option_html = $('#elements').find('div.option-row');
                    $('.options').append(option_html.html());
                });

                //delete option on click 
                $(document).on('click', '.option-delete', function () {
                    console.log($(this).parent('div.option-row').html());
                    $(this).closest('div.option-row').remove();
                });
            });
        </script>
    </div>
</div>