<?php

use App\Http\Controllers\Helpers\Html\Components;
use App\Http\Controllers\Helpers\Functions;

if (!isset($certification))
    $certification = new \App\Models\Certifications();

$x = 12 / count($languages);
?>
<div class="card-content collapse show">
    <div class="card-body">
        <form class="steps-validation wizard-circle" method="post" enctype="multipart/form-data">

            <!-- Step 1 -->
            <h6>common things</h6>
            <fieldset>
                <div class="row">
                    <input type="hidden" name="image" value="{{$certification->logo_id}}"/>
                    <input type="hidden" name="image_id" value="{{$certification->image_id}}"/>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>
                                <label >Logo :</label>
                                <?= Components::uploader($certification->logo_id)?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Image</label>
                              <?= Components::upload($certification->image_id, '','image_id')?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-9">
                            <div class="form-group">
                                <label>Files</label>
                                <input type="file" name="decauments[]" multiple="" accept="application/pdf,application/vnd.ms-excel">
                                <br/>
                                @foreach($certification->files as $file)
                                <a href="{{$file->filePAth}}">تحميل</a><br/>
                                @endforeach
                            </div>
                        </div>


                        <input type="hidden" value="1" name="save"/>
                    </div>


            </fieldset>

            @foreach($languages as $key=>$lang)
            <!-- Step 2 -->
            <h6>{{$lang->name}}</h6>
            <fieldset>
                <div class="row col-md-12">

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >Title : *</label>
                            <input type="text" name="title_{{$lang->id}}" @if($certification->langs()->where('language_id',$lang->id)->first()) value='{{$certification->langs()->where('language_id',$lang->id)->first()->title}}' @endif class="form-control required" required="">
                        </div>

                    </div>


                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >Sub Description : </label>
                            <textarea name="sub_description_{{$lang->id}}" cols="6" rows="6" class="form-control required" required=""> @if($certification->langs()->where('language_id',$lang->id)->first()) {{$certification->langs()->where('language_id',$lang->id)->first()->sub_description}} @endif</textarea>
                        </div>
                    </div>

                </div>
                <hr/>
                <div class="row col-md-12">
                    <div class="form-group">
                        <label class="label-control"  >Description : </label>

                        <textarea name="description_{{$lang->id}}" cols="6" rows="6" class="form-control editor" required=""> @if($certification->langs()->where('language_id',$lang->id)->first()) {{$certification->langs()->where('language_id',$lang->id)->first()->description}} @endif</textarea>
                    </div>
                </div>
                <hr/>
                <div class="row col-md-12">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >meta Title : *</label>
                            <input type="text" name="meta_title_{{$lang->id}}" @if($certification->langs()->where('language_id',$lang->id)->first()) value='{{$certification->langs()->where('language_id',$lang->id)->first()->meta_title}}' @endif class="form-control" >
                        </div>

                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="label-control"  >meta KeyWords : *</label>
                            <input type="text" name="meta_keywords_{{$lang->id}}" @if($certification->langs()->where('language_id',$lang->id)->first()) value='{{$certification->langs()->where('language_id',$lang->id)->first()->meta_keywords}}' @endif class="form-control" >
                        </div>

                    </div>
                </div>
                <hr/>
                <div class="row col-md-12">
                    <div class="col-md-12">
                        <label class="label-control" >Meta Description : </label>
                        <textarea name="meta_description_{{$lang->id}}" cols="6" class="form-control" > @if($certification->langs()->where('language_id',$lang->id)->first()) {{$certification->langs()->where('language_id',$lang->id)->first()->meta_description}} @endif</textarea>

                    </div>
                </div>
                <hr/>
            </fieldset>
            @endforeach
            <!-- Step 3 -->


        </form>
    </div>
    <script>
        $(document).ready(function () {

        @if ($certification -> exists)
                $('[role=tablist]').find("[role=tab]").removeClass('disabled')
                @endif
                $("#form").validate({
        rules: {
        description: {
        required: true
        },
                language_id: {
                required: true
                },
                images: {
                required: true
                }


        }
        });
        });
    </script>
</div>
