<?php

use App\Http\Controllers\Helpers\Html\Components;
use App\Http\Controllers\Helpers\Functions;

if (!isset($goal))
    $goal = new \App\Models\Categories();

$x=12/count($languages);
?>
<div class="card-content collapse show">
    <div class="card-body">
        <form method="post" class="form-horizontal" id="form">
            <div class="form-body">
                @csrf
           
                  <div class="form-group">
                  <div class="form-group">
                    <div class="row col-sm-12">
                        @foreach ($languages as $language)
                        <div class="col-md-{{$x}}">
                            <label class="control-label">{{$language->name}} Title </label>
                            <input type="text" class="form-control" name="title_{{$language->id}}" @if($goal->langs()->where('language_id',$language->id)->first())  value="{{$goal->langs()->where('language_id',$language->id)->first()->title}}" @endif required/>
                        </div>
                        @endforeach
                    </div>
                  </div>

                      <input value="{{$goal->image_id}}" name="image" type="hidden"/>
            
              
                <div class="form-group">
                    <div class="row col-sm-12">
                        <div class="col-sm-6">
                        <label class="control-label">Image</label>
                        <?= Components::uploader($goal->image_id) ?>
                        </div>
                        <div class="col-sm-6">
                        <label class="control-label">Parent Category</label>
                            <select name="parent_id" class="form-control">
                        <option value="">Main Category</option>
                            @foreach(\App\Models\Categories::whereNull('parent_id')->get() as $one)
                                <option value="{{$one->id}}" {{$goal->parent_id==$one->id?'selected':''}}>{{$one->lang->title}}</option>
                            @endforeach
                            </select>
                        </div>
                        
                    </div>
                </div>
            </div>
            </div>
            <div class="form-actions">
                <div class="form-group">
                    <input type="submit" name="save" class="btn btn-outline btn-primary" value="Save Changes" />
                </div>
            </div>
        </form>
       
        <div id="text" style="display: none">
            <input name="value" type="text" placeholder="put value" class="form-control">
        </div>
        <script>
            $(document).ready(function () {

                $("#form").validate({
                    rules: {
                        description: {
                            required: true
                        },
                        language_id: {
                            required: true
                        },
                        images: {
                            required: true
                        }


                    }
                });
            });
        </script>
    </div>
</div>