@extends('backend.layout')
@section('title','Careers Data')
@section('content')
<?php

use App\Http\Controllers\Helpers\Html\Themes;
use App\Http\Controllers\Helpers\Functions;
?>
<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">Careers Data</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Home</a>
                    </li>


                    <li class="breadcrumb-item">Careers
                    </li>

                </ol>
            </div>
        </div>
    </div>

</div>

<div class="content-body" ><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling"  style="">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-6"><h4 class="card-title">Careers</h4>
                        </div>
                        <div class="col-md-6">
                            <a href="{{url(URL::current().'/download')}}" class="d-inline btn btn-xs btn-primary">Download Sheet </a>          
                                    
                               
                        </div>
                    </div>
                </div>
                <div class="card-content collapse show">

                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Date</th>
                                    <th>Name</th>
                                    <th>Years <br/> Of <br/>Experience</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Age</th>
                                    <th>Job <br/> Title</th>
                                    <th>C.v</th>
                                    <th>Settings</th>
                                   
                              
                                   
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($result as $row)
                                <tr>


                                    <td>{{$row->id}}</td>
                                    <td>{{date('Y-m-d',strtotime($row->created_at))}}</td>
                                    <td>{{$row->name}}</td>
                                    <td>{{$row->years}} </td>
                                    <td>{{$row->email}}</td>
                                    <td>{{$row->phone}}</td>
                                    <td>{{$row->age}}</td>
                                    <td>{{$row->job_title}}</td>
                                    <td><a href="{{url($row->cv)}}" download class="btn btn-primary">C.V</a></td>
                                    <td>   {!!Themes::deleteRow($row->id, url(\URL::Current().'/delete'),[])!!}</td>
                                    
                                    
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>

                </div>
            </div>
        </div>
    </div>

      <?php  $search_query = \Illuminate\Support\Facades\Input::except('page');
                    $result->appends($search_query); ?>
            {!! $result->links()!!}
                    
</div>

@stop()