@extends('backend.layout')
@section('title','Create New Banner | الصفحات')
@section('content')
@include('backend.message')

<div class="content-header row">
    <div class="content-header-left col-md-6 col-12 mb-2">
        <h3 class="content-header-title mb-0">الصفحات</h3>
        <div class="row breadcrumbs-top">
            <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('backend/dashboard')}}">Home</a>
                    </li>
                    <li class="breadcrumb-item"><a href="{{url('backend/pages')}}">الصفحات</a>
                    </li>
                    <li class="breadcrumb-item">Create الصفحات
                    </li>

                </ol>
            </div>
        </div>
    </div>

</div>
<div class="content-body"><!-- Default styling start -->

    <!-- Default styling end -->
    <!-- Table header styling start -->
    <div class="row" id="header-styling">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">الصفحات</h4>


                </div>
                <div class="card-content collapse show">
                    <div class="card-body">
                        @if(\Session::get('errors')!==null)


                        <div class="alert alert-danger">
                            {{\Session::get('errors')}}
                        </div>

                        @endif
                        @if(\Session::get('success')!==null)


                        <div class="alert alert-success">
                            {{\Session::get('success')}}
                        </div>

                        @endif
                        <form class="form-horizontal" role="form" method="post">
                            <div class="form-group">
                                <label class="col-md-2 control-label">{{trans('cms-backend-auth.name')}}</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="name" placeholder="{{trans('cms-backend-auth.enter-user-name')}}" required="">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-2 control-label">{{trans('cms-backend-auth.link')}}</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="link" placeholder="{{trans('cms-backend-auth.enter-link')}}" required="">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-2 control-label">{{trans('cms-backend-auth.module')}}</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="module" placeholder="{{trans('cms-backend-auth.enter-module')}}" required="">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-md-2 control-label">{{trans('cms-backend-auth.action')}}</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="action" placeholder="{{trans('cms-backend-auth.enter-action')}}" required="">
                                </div>
                            </div>


                            {{ csrf_field() }}
                            <button class="btn btn-purple waves-effect m-b-5" type="submit">{{trans('cms-backend-auth.save')}}</button>






                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<?php
\Session::forget('errors');
\Session::forget('success');
?>
@endsection