<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
               $table->dropColumn('name');
               $table->string('firstname');
               $table->string('lastname');
               $table->string('reset_password_token')->nullable();
               $table->datetime('reset_password_at');
               $table->string('telephone');
               $table->string('fax')->nullable();
               $table->integer('newsletter')->default(0);
               $table->integer('country_id');
               $table->integer('city_id');
               $table->string('city');
               $table->string('address');
               $table->string('company')->nullable();
               $table->string('postal_code')->nullable();
               $table->integer('status');
        });
        //
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
