<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('category_id');
            $table->integer('image_id');
            $table->double('price',12,2);
            $table->integer('discount_precent')->nullable();
            $table->double('price_after_discount',12,2)->nullable();
            $table->double('discount',12,2)->nullable();
            $table->double('rating',12,2)->nullable();
            $table->integer('number_of_rating')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
