<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLanguagesTable extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('languages', function(Blueprint $table) {
            $table->integer('id', true);
            $table->string('name');
            $table->string('symbol');

            $table->boolean('is_active');
            $table->string('direction');
            $table->timestamps();
            $table->integer('sort')->nullable();
        });
        \DB::table('languages')->insert(
                array(
                    'name' => 'English',
                    'symbol' => 'en',
                    'is_active' => true,
                    'rtl' => false,
                )
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::drop('languages');
    }

}
