<?php

namespace App\Models\traits;

trait TraitLanguage {

    function getLanguageAttribute() {

        return $this->hasMany(__CLASS__ . 'Languages', str_singular($this->table) . '_id')->first();
    }
    function getLanguagearAttribute() {

        return $this->hasOne(__CLASS__ . 'Languages', str_singular($this->table) . '_id')->where('language_id',4)->first();
    }
    function getLanguageenAttribute() {

           return $this->hasOne(__CLASS__ . 'Languages', str_singular($this->table) . '_id')->where('language_id',1)->first();

    }
    

    function getLangAttribute() {

     
                    if (\Session::has('language_id')) {
                        $language_id = session('language_id');

                        $object = $this->hasOne(__CLASS__ . 'Languages', str_singular($this->table) . '_id')->where('language_id', $language_id)->first();
                        return $object ? $object : $this->hasOne(__CLASS__ . 'Languages', str_singular($this->table) . '_id')->first();
                    }
                    return $this->hasMany(__CLASS__ . 'Languages', str_singular($this->table) . '_id')->first();
                
    }

    static function boot() {
        $languages = \App\Models\Languages::all();

        parent::boot();
        parent::deleting(function($model)use($languages) {
            foreach ($languages as $language) {
                cache()->forget($model->table . '_languages_' . $model->id . '_' . $language->id);
            }
        });
    }

}

?>