<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class Services extends BaseModel {

    use traits\TraitLanguage;

    protected $table = 'services';
    public $rules = [
        'image_id' => 'required',
        'icon_id' => 'required',
        'hover_icon_id' => 'required',
    ];
    protected $guarded = ['id'];

    function getIconAttribute() {
      
                    if ($this->icon_id != '')
                        return url($this->icon_id);
                return '';
    }
    function getHoverIconAttribute() {
      
                    if ($this->hover_icon_id != '')
                        return url($this->hover_icon_id);
                return '';
    }
    function getImageAttribute() {
      
                    if ($this->image_id != '')
                        return url($this->image_id);
                return '';
    }
    function getDiscoverFilePathAttribute() {
      
                    if ($this->discover_file != '')
                        return url($this->discover_file);
                return '';
    }
    function langs(){
        return $this->hasMany(ServicesLanguages::class,'service_id');
    }
    function lang(){
        return $this->hasOne(ServicesLanguages::class,'service_id');
    }

  
}
