<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class SecondaryCategories extends BaseModel {

    use traits\TraitLanguage;

    protected $table = 'secondary_categories';
    public $rules = [
        'image_id' => 'required'
    ];
    protected $guarded = ['id'];

    function getImageAttribute() {
   
                    if ($this->image_id !='')
                        return url($this->image_id);
              return '';
    }
        function getThumbAttribute() {
       
                    if ($this->image_id != '')
                    {
                        $image= str_replace('uploads', 'uploads/thumbs', $this->image_id);
                        if(file_exists(url($image)))
                            return url($image);
                        else return url($this->image_id);
                    }
                return '';
    }
    function langs(){
        return $this->hasMany(SecondaryCategoriesLanguages::class,'secondary_category_id');
    }
    function category(){
        return $this->belongsTo(MainCategories::class,'main_category_id');
    }
    

}
