<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class Products extends BaseModel {

    use traits\TraitLanguage;

    protected $table = 'products';
    public $rules = [
        'image_id' => 'required'
    ];
    protected $guarded = ['id'];

    function getImageAttribute() {
   
                    if ($this->image_id != '')
                        return url($this->image_id);
              return '';
    }
    function langs(){
        return $this->hasMany(ProductsLanguages::class,'product_id');
    }
    function category(){
        return $this->belongsTo(SecondaryCategories::class,'category_id');
    }
    function images(){
        return $this->hasMany(ProductsImages::class,'product_id');
    }
    function getDiscoverFilePathAttribute() {

        if ($this->discover_file != '')
            return url($this->discover_file);
        return '';
    }

}
