<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class News extends BaseModel {

    use traits\TraitLanguage;

    protected $table = 'news';
    public $rules = [
        'image_id' => 'required'
    ];
    protected $guarded = ['id'];

    function getImageAttribute() {
   
                    if ($this->image_id != '')
                        return url($this->image_id);
              return '';
    }
        function getThumbAttribute() {
       
                    if ($this->image_id != '')
                    {
                        $image= str_replace('uploads', 'uploads/thumbs', $this->image_id);
                       
                        if(file_exists($image))
                            return url($image);
                        else return url($this->image_id);
                    }
                return '';
    }
    function langs(){
        return $this->hasMany(NewsLanguages::class,'news_id');
    }
    function lang(){
        return $this->hasOne(NewsLanguages::class,'news_id');
    }

    

}
