<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class MainCategories extends BaseModel {

    use traits\TraitLanguage;

    protected $table = 'main_categories';
    public $rules = [
        'image_id' => 'required'
    ];
    protected $guarded = ['id'];

    function getImageAttribute() {
   
                    if ($this->image_id != '')
                        return url($this->image_id);
              return '';
    }
        function getThumbAttribute() {
       
                    if ($this->image_id != '')
                    {
                        $image= str_replace('uploads', 'uploads/thumbs', $this->image_id);
                        if(file_exists($image))
                            return url($image);
                        else return url($this->image_id);
                    }
                return '';
    }
    function langs(){
        return $this->hasMany(MainCategoriesLanguages::class,'main_category_id');
    }
    function secondary(){
        return $this->hasMany(SecondaryCategories::class,'main_category_id');
    }

    

}
