<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\BaseModel;

class Languages extends BaseModel
{



    protected $table = 'languages';
    public $timestamps = true;
    public $ignored_unique = [
        'name',
        'symbol',
    ];
    public $rules = [
        'name' => 'required|unique:languages,name',
        'symbol' => 'required|unique:languages,symbol',
        'direction' => 'required'
    ];
    protected $guarded = ['id'];
    function getImagePathAttribute(){
        if($this->image)
            return url($this->image);
        return '';
    }
}
