<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class IndexSections extends BaseModel
{

    use traits\TraitLanguage;

    protected $table = 'index_sections';
    public $rules = [
        'image_id' => 'required'
    ];
    protected $guarded = ['id'];

    function getImageAttribute()
    {

        if ($this->image_id != '')
            return url($this->image_id);
        return '';
    }
    function langs()
    {
        return $this->hasMany(IndexSectionsLanguages::class, 'index_section_id');
    }
    function lang()
    {
        return $this->hasOne(IndexSectionsLanguages::class, 'index_section_id');
    }
}
