<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class Events extends BaseModel {

    use traits\TraitLanguage;

    protected $table = 'events';
    public $rules = [
        'image_id' => 'required'
    ];
    protected $guarded = ['id'];

    function getImageAttribute() {
   
                    if ($this->image_id != '')
                        return url($this->image_id);
              return '';
    }
        function getThumbAttribute() {
       
                    if ($this->image_id != '')
                    {
                        $image= str_replace('uploads', 'uploads/thumbs', $this->image_id);
                        if(file_exists($image))
                            return url($image);
                        else return url($this->image_id);
                    }
                return '';
    }
    function langs(){
        return $this->hasMany(EventsLanguages::class,'event_id');
    }
    function lang(){
        return $this->hasOne(EventsLanguages::class,'event_id');
    }

    

}
